/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.wildfly.clustering.cache.CacheEntryLocator;

public interface BiCacheEntryLocator<I, K, V>
extends CacheEntryLocator<I, Map.Entry<K, V>> {
    public Map.Entry<CompletionStage<K>, CompletionStage<V>> findEntry(I var1);

    default public Map.Entry<CompletionStage<K>, CompletionStage<V>> tryEntry(I id) {
        return this.findEntry(id);
    }

    @Override
    default public CompletionStage<Map.Entry<K, V>> findValueAsync(I id) {
        Map.Entry<CompletionStage<K>, CompletionStage<V>> entry = this.findEntry(id);
        return entry.getKey().thenCombine(entry.getValue(), (key, value) -> key != null && value != null ? Map.entry(key, value) : null);
    }

    @Override
    default public CompletionStage<Map.Entry<K, V>> tryValueAsync(I id) {
        Map.Entry<CompletionStage<K>, CompletionStage<V>> entry = this.tryEntry(id);
        return entry.getKey().thenCombine(entry.getValue(), (key, value) -> key != null && value != null ? Map.entry(key, value) : null);
    }
}

