/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessageBrokerAccessor;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationEventSupport;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Terminus;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationEventProcessor
extends ProtonAbstractReceiver {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int PROCESSOR_RECEIVER_CREDITS = 10;
    private static final int PROCESSOR_RECEIVER_CREDITS_LOW = 3;
    private final ActiveMQServer server;
    private final AMQPFederation federation;

    public AMQPFederationEventProcessor(AMQPFederation federation, AMQPSessionContext session, Receiver receiver) {
        super(session.getSessionSPI(), session.getAMQPConnectionContext(), session, receiver);
        this.server = this.protonSession.getServer();
        this.federation = federation;
    }

    @Override
    public void initialize() throws Exception {
        this.initialized = true;
        this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
        this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        if (this.receiver.getLocalState() != EndpointState.ACTIVE) {
            this.receiver.setOfferedCapabilities(new Symbol[]{AMQPFederationConstants.FEDERATION_EVENT_LINK});
            Terminus remoteTerminus = (Terminus)this.receiver.getRemoteTarget();
            if (remoteTerminus == null || !remoteTerminus.getDynamic()) {
                throw new ActiveMQAMQPInternalErrorException("Remote Terminus did not arrive as dynamic node: " + remoteTerminus);
            }
            remoteTerminus.setAddress(this.receiver.getName());
        }
        this.federation.registerEventReceiver(this);
        this.flow();
    }

    @Override
    protected void actualDelivery(Message message, Delivery delivery, DeliveryAnnotations deliveryAnnotations, Receiver receiver, Transaction tx) {
        logger.trace("{}::actualdelivery called for {}", (Object)this.server, (Object)message);
        AMQPMessage eventMessage = (AMQPMessage)message;
        delivery.setContext((Object)message);
        try {
            Object eventType = AMQPMessageBrokerAccessor.getMessageAnnotationProperty(eventMessage, AMQPFederationConstants.EVENT_TYPE);
            if ("REQUESTED_QUEUE_ADDED_EVENT".equals(eventType)) {
                Map<String, Object> eventData = AMQPFederationEventSupport.decodeQueueAddedEvent(eventMessage);
                String addressName = eventData.get("REQUESTED_ADDRESS_NAME").toString();
                String queueName = eventData.get("REQUESTED_QUEUE_NAME").toString();
                logger.trace("Remote event indicates Queue added that matched a previous request [{}::{}]", (Object)addressName, (Object)queueName);
                this.federation.processRemoteQueueAdded(addressName, queueName);
            } else if ("REQUESTED_ADDRESS_ADDED_EVENT".equals(eventType)) {
                Map<String, Object> eventData = AMQPFederationEventSupport.decodeAddressAddedEvent(eventMessage);
                String addressName = eventData.get("REQUESTED_ADDRESS_NAME").toString();
                logger.trace("Remote event indicates Address added that matched a previous request [{}]", (Object)addressName);
                this.federation.processRemoteAddressAdded(addressName);
            } else {
                this.federation.signalError((Exception)((Object)new ActiveMQAMQPInternalErrorException("Remote sent unknown event.")));
                return;
            }
            delivery.disposition((DeliveryState)Accepted.getInstance());
            delivery.settle();
            this.flow();
            this.connection.flush();
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            this.federation.signalError((Exception)((Object)new ActiveMQAMQPInternalErrorException("Error while processing incoming event message: " + e.getMessage())));
        }
    }

    @Override
    protected Runnable createCreditRunnable(AMQPConnectionContext connection) {
        return AMQPFederationEventProcessor.createCreditRunnable(10, 3, this.receiver, connection, this);
    }

    @Override
    public void flow() {
        this.creditRunnable.run();
    }
}

