/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote.attributes;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.CacheEntryMutator;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.cache.function.Functions;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheEntryMutatorFactory;
import org.wildfly.clustering.marshalling.Marshallability;
import org.wildfly.clustering.marshalling.Marshaller;
import org.wildfly.clustering.server.immutable.Immutability;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.ImmutableSessionMetaData;
import org.wildfly.clustering.session.cache.CompositeImmutableSession;
import org.wildfly.clustering.session.cache.attributes.SessionAttributes;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.infinispan.remote.attributes.SessionAttributesKey;

public class CoarseSessionAttributesFactory<C, V>
implements SessionAttributesFactory<C, Map<String, Object>> {
    private static final Logger LOGGER = Logger.getLogger(CoarseSessionAttributesFactory.class);
    private final RemoteCache<SessionAttributesKey, V> cache;
    private final Flag[] ignoreReturnFlags;
    private final Marshaller<Map<String, Object>, V> marshaller;
    private final Immutability immutability;
    private final CacheProperties properties;
    private final CacheEntryMutatorFactory<SessionAttributesKey, V> mutatorFactory;
    private final BiFunction<ImmutableSession, C, SessionActivationNotifier> notifierFactory;

    public CoarseSessionAttributesFactory(SessionAttributesFactoryConfiguration<Map<String, Object>, V> configuration, BiFunction<ImmutableSession, C, SessionActivationNotifier> notifierFactory, RemoteCacheConfiguration hotrod) {
        this.cache = hotrod.getCache();
        this.ignoreReturnFlags = hotrod.getIgnoreReturnFlags();
        this.marshaller = configuration.getMarshaller();
        this.immutability = configuration.getImmutability();
        this.properties = hotrod.getCacheProperties();
        this.mutatorFactory = new RemoteCacheEntryMutatorFactory(this.cache, this.ignoreReturnFlags);
        this.notifierFactory = notifierFactory;
    }

    public CompletionStage<Map<String, Object>> createValueAsync(String id, Void context) {
        ConcurrentHashMap attributes = new ConcurrentHashMap();
        try {
            Object value = this.marshaller.write(attributes);
            return this.cache.withFlags(this.ignoreReturnFlags).putAsync((Object)new SessionAttributesKey(id), value).thenApply(Functions.constantFunction(attributes));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public CompletionStage<Map<String, Object>> findValueAsync(String id) {
        return this.getValueAsync(id).exceptionally(e -> {
            LOGGER.warn((Object)e.getLocalizedMessage(), e);
            this.removeAsync(id);
            return null;
        });
    }

    public CompletionStage<Map<String, Object>> tryValueAsync(String id) {
        return this.getValueAsync(id).exceptionally(Functions.nullFunction());
    }

    private CompletionStage<Map<String, Object>> getValueAsync(String id) {
        return this.cache.getAsync((Object)new SessionAttributesKey(id)).thenApply(value -> {
            try {
                return value != null ? (Map)this.marshaller.read(value) : null;
            }
            catch (IOException e) {
                throw new UncheckedIOException(id, e);
            }
        });
    }

    public CompletionStage<Void> removeAsync(String id) {
        return this.cache.withFlags(this.ignoreReturnFlags).removeAsync((Object)new SessionAttributesKey(id)).thenAccept(org.wildfly.common.function.Functions.discardingConsumer());
    }

    public SessionAttributes createSessionAttributes(String id, Map<String, Object> attributes, ImmutableSessionMetaData metaData, C context) {
        try {
            CacheEntryMutator mutator = this.mutatorFactory.createMutator((Object)new SessionAttributesKey(id), this.marshaller.write(attributes));
            SessionActivationNotifier notifier = this.properties.isPersistent() ? this.notifierFactory.apply((ImmutableSession)new CompositeImmutableSession(id, metaData, attributes), context) : null;
            return new CoarseSessionAttributes(attributes, mutator, this.properties.isMarshalling() ? this.marshaller : Marshallability.TRUE, this.immutability, notifier);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Map<String, Object> createImmutableSessionAttributes(String id, Map<String, Object> values) {
        return Map.copyOf(values);
    }

    public void close() {
    }
}

