/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.DelegatingServiceTarget;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.singleton.Singleton;
import org.wildfly.clustering.singleton.SingletonPolicy;
import org.wildfly.clustering.singleton.compat.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.compat.SingletonServiceTargetFactory;
import org.wildfly.clustering.singleton.election.SingletonElectionListener;
import org.wildfly.clustering.singleton.election.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.service.ServiceTargetFactory;
import org.wildfly.clustering.singleton.service.SingletonServiceController;
import org.wildfly.clustering.singleton.service.SingletonServiceTarget;
import org.wildfly.extension.clustering.singleton.RandomElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SimpleElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonDeploymentResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonExtension;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResource;
import org.wildfly.extension.clustering.singleton.SingletonServiceResourceDefinition;
import org.wildfly.service.capture.FunctionExecutorRegistry;
import org.wildfly.service.capture.ServiceValueExecutorRegistry;
import org.wildfly.service.capture.ServiceValueRegistry;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class SingletonPolicyResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator {
    static final PathElement WILDCARD_PATH = SingletonPolicyResourceDefinition.pathElement("*");
    private static final RuntimeCapability<Void> SERVICE_TARGET_FACTORY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ServiceTargetFactory.SERVICE_DESCRIPTOR).build();
    private final ServiceValueExecutorRegistry<Singleton> registry = ServiceValueExecutorRegistry.newInstance();
    private final ResourceModelResolver<BinaryServiceConfiguration> resolver = BinaryServiceConfiguration.resolver((AttributeDefinition)Attribute.CACHE_CONTAINER.getDefinition(), (AttributeDefinition)Attribute.CACHE.getDefinition());

    static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"singleton-policy", (String)value);
    }

    SingletonPolicyResourceDefinition() {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)SingletonExtension.SUBSYSTEM_RESOLVER.createChildResolver(WILDCARD_PATH));
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(List.of(SERVICE_TARGET_FACTORY)).addRequiredSingletonChildren(new PathElement[]{SimpleElectionPolicyResourceDefinition.PATH}).setResourceTransformation(SingletonPolicyResource::new);
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new RandomElectionPolicyResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new SimpleElectionPolicyResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new SingletonDeploymentResourceDefinition((FunctionExecutorRegistry<ServiceName, Singleton>)this.registry).register(registration);
            new SingletonServiceResourceDefinition((FunctionExecutorRegistry<ServiceName, Singleton>)this.registry).register(registration);
        }
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        BinaryServiceConfiguration configuration = (BinaryServiceConfiguration)this.resolver.resolve(context, model);
        final int quorum = Attribute.QUORUM.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final ServiceDependency electionPolicy = ServiceDependency.on((UnaryServiceDescriptor)SingletonElectionPolicy.SERVICE_DESCRIPTOR, (String)name);
        final ServiceDependency targetFactory = configuration.getServiceDependency(org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory.SERVICE_DESCRIPTOR).map(SingletonServiceTargetFactory.class::cast);
        ServiceValueExecutorRegistry<Singleton> registry = this.registry;
        final SingletonPolicyResource registrar = (SingletonPolicyResource)context.readResource(PathAddress.EMPTY_ADDRESS);
        SingletonServiceTargetFactory serviceTargetFactory = new SingletonServiceTargetFactory(){
            final /* synthetic */ ServiceValueRegistry val$registry;
            final /* synthetic */ String val$name;
            {
                this.val$registry = serviceValueRegistry;
                this.val$name = string;
            }

            public SingletonServiceTarget createSingletonServiceTarget(ServiceTarget target) {
                SingletonServiceTarget singletonTarget = ((SingletonServiceTargetFactory)targetFactory.get()).createSingletonServiceTarget(target);
                return new ConfiguredSingletonServiceTarget(singletonTarget, builder -> builder.withElectionPolicy((SingletonElectionPolicy)electionPolicy.get()).requireQuorum(quorum), (Registrar<ServiceName>)registrar, (ServiceValueRegistry<Singleton>)this.val$registry);
            }

            @Deprecated
            public SingletonServiceConfigurator createSingletonServiceConfigurator(ServiceName name) {
                org.wildfly.clustering.singleton.compat.SingletonServiceConfigurator configurator = ((SingletonServiceTargetFactory)targetFactory.get()).createSingletonServiceConfigurator(name).withElectionPolicy((SingletonElectionPolicy)electionPolicy.get()).requireQuorum(quorum);
                return new SingletonServiceConfigurator(configurator, (Registrar<ServiceName>)registrar, (ServiceValueRegistry<Singleton>)this.val$registry);
            }

            @Deprecated
            public <T> SingletonServiceBuilder<T> createSingletonServiceBuilder(ServiceName name, org.jboss.msc.service.Service<T> service) {
                SingletonServiceBuilder builder = ((SingletonServiceTargetFactory)targetFactory.get()).createSingletonServiceBuilder(name, service).withElectionPolicy((SingletonElectionPolicy)electionPolicy.get()).requireQuorum(quorum);
                return new LegacySingletonServiceBuilder(builder, (Registrar<ServiceName>)registrar, (ServiceValueRegistry<Singleton>)this.val$registry);
            }

            @Deprecated
            public <T> SingletonServiceBuilder<T> createSingletonServiceBuilder(ServiceName name, org.jboss.msc.service.Service<T> primaryService, org.jboss.msc.service.Service<T> backupService) {
                SingletonServiceBuilder builder = ((SingletonServiceTargetFactory)targetFactory.get()).createSingletonServiceBuilder(name, primaryService, backupService).withElectionPolicy((SingletonElectionPolicy)electionPolicy.get()).requireQuorum(quorum);
                return new LegacySingletonServiceBuilder(builder, (Registrar<ServiceName>)registrar, (ServiceValueRegistry<Singleton>)this.val$registry);
            }

            public String toString() {
                return this.val$name;
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(SERVICE_TARGET_FACTORY, (Object)serviceTargetFactory).requires(List.of(electionPolicy, targetFactory))).provides(ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)org.wildfly.clustering.singleton.service.SingletonPolicy.SERVICE_DESCRIPTOR, (String)name))).provides(ServiceNameFactory.resolveServiceName((UnaryServiceDescriptor)SingletonPolicy.SERVICE_DESCRIPTOR, (String)name))).build();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        CACHE_CONTAINER("cache-container", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setRequired(true)).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(SERVICE_TARGET_FACTORY, (UnaryServiceDescriptor)org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory.DEFAULT_SERVICE_DESCRIPTOR).build());
            }
        }
        ,
        CACHE("cache", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setRequired(false)).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(SERVICE_TARGET_FACTORY, (BinaryServiceDescriptor)org.wildfly.clustering.singleton.service.SingletonServiceTargetFactory.SERVICE_DESCRIPTOR).withParentAttribute(CACHE_CONTAINER.getDefinition()).build());
            }
        }
        ,
        QUORUM("quorum", ModelType.INT){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode(1))).setValidator(new IntRangeValidatorBuilder().min(1).configure((AbstractAttributeDefinitionBuilder)builder).build());
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)this.apply(new SimpleAttributeDefinitionBuilder(name, type))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    @Deprecated
    private class LegacySingletonServiceBuilder<T>
    implements SingletonServiceBuilder<T> {
        private final SingletonServiceBuilder<T> builder;
        private final Registrar<ServiceName> registrar;
        private final ServiceValueRegistry<Singleton> registry;

        LegacySingletonServiceBuilder(SingletonServiceBuilder<T> builder, Registrar<ServiceName> registrar, ServiceValueRegistry<Singleton> registry) {
            this.builder = builder;
            this.registrar = registrar;
            this.registry = registry;
        }

        public ServiceName getServiceName() {
            return this.builder.getServiceName();
        }

        public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> build(ServiceTarget target) {
            return new ConfiguredSingletonServiceBuilder(this.getServiceName(), this.builder.build(target), this.registrar, this.registry);
        }

        public SingletonServiceBuilder<T> withElectionPolicy(SingletonElectionPolicy policy) {
            this.builder.withElectionPolicy(policy);
            return this;
        }

        public SingletonServiceBuilder<T> withElectionListener(SingletonElectionListener listener) {
            this.builder.withElectionListener(listener);
            return this;
        }

        public SingletonServiceBuilder<T> requireQuorum(int quorum) {
            this.builder.requireQuorum(quorum);
            return this;
        }
    }

    @Deprecated
    private class SingletonServiceConfigurator
    implements org.wildfly.clustering.singleton.compat.SingletonServiceConfigurator {
        private final org.wildfly.clustering.singleton.compat.SingletonServiceConfigurator configurator;
        private final Registrar<ServiceName> registrar;
        private final ServiceValueRegistry<Singleton> registry;

        SingletonServiceConfigurator(org.wildfly.clustering.singleton.compat.SingletonServiceConfigurator configurator, Registrar<ServiceName> registrar, ServiceValueRegistry<Singleton> registry) {
            this.configurator = configurator;
            this.registrar = registrar;
            this.registry = registry;
        }

        public ServiceName getServiceName() {
            return this.configurator.getServiceName();
        }

        public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<?> build(ServiceTarget target) {
            return new ConfiguredSingletonServiceBuilder(this.getServiceName(), this.configurator.build(target), this.registrar, this.registry);
        }

        public org.wildfly.clustering.singleton.compat.SingletonServiceConfigurator withElectionPolicy(SingletonElectionPolicy policy) {
            this.configurator.withElectionPolicy(policy);
            return this;
        }

        public org.wildfly.clustering.singleton.compat.SingletonServiceConfigurator withElectionListener(SingletonElectionListener listener) {
            this.configurator.withElectionListener(listener);
            return this;
        }

        public org.wildfly.clustering.singleton.compat.SingletonServiceConfigurator requireQuorum(int quorum) {
            this.configurator.requireQuorum(quorum);
            return this;
        }
    }

    private static class ConfiguredSingletonServiceBuilder<T>
    extends DelegatingServiceBuilder<T>
    implements org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> {
        private final org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> builder;
        private final AtomicReference<ServiceName> name = new AtomicReference();
        private final Registrar<ServiceName> registrar;
        private final ServiceValueRegistry<Singleton> registry;

        ConfiguredSingletonServiceBuilder(ServiceName name, org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> builder, Registrar<ServiceName> registrar, ServiceValueRegistry<Singleton> registry) {
            super(builder);
            this.name.set(name);
            this.builder = builder;
            this.registrar = registrar;
            this.registry = registry;
        }

        public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> requireQuorum(int quorum) {
            this.builder.requireQuorum(quorum);
            return this;
        }

        public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> withElectionPolicy(SingletonElectionPolicy policy) {
            this.builder.withElectionPolicy(policy);
            return this;
        }

        public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> withElectionListener(SingletonElectionListener listener) {
            this.builder.withElectionListener(listener);
            return this;
        }

        public <V> Consumer<V> provides(ServiceName ... names) {
            this.name.compareAndSet(null, names[0]);
            return super.provides(names);
        }

        public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> setInstance(Service service) {
            this.name.compareAndSet(null, ServiceName.parse((String)service.getClass().getName()));
            this.builder.setInstance(service);
            return this;
        }

        public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
            this.builder.setInitialMode(mode);
            return this;
        }

        public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> addListener(LifecycleListener listener) {
            this.builder.addListener(listener);
            return this;
        }

        public SingletonServiceController<T> install() {
            SingletonServiceController controller = this.builder.install();
            final ServiceName name = this.name.get();
            if (name != null) {
                final ServiceValueRegistry<Singleton> registry = this.registry;
                final Consumer captor = registry.add((Object)name);
                captor.accept(controller);
                final Registration registration = this.registrar.register((Object)name);
                controller.addListener(new LifecycleListener(){

                    public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
                        if (event == LifecycleEvent.REMOVED) {
                            registration.close();
                            captor.accept(null);
                            registry.remove((Object)name);
                        }
                    }
                });
            }
            return controller;
        }
    }

    private static class ConfiguredSingletonServiceTarget
    extends DelegatingServiceTarget
    implements SingletonServiceTarget {
        private final SingletonServiceTarget target;
        private final UnaryOperator<org.wildfly.clustering.singleton.service.SingletonServiceBuilder<?>> configurator;
        private final Registrar<ServiceName> registrar;
        private final ServiceValueRegistry<Singleton> registry;

        ConfiguredSingletonServiceTarget(SingletonServiceTarget target, UnaryOperator<org.wildfly.clustering.singleton.service.SingletonServiceBuilder<?>> configurator, Registrar<ServiceName> registrar, ServiceValueRegistry<Singleton> registry) {
            super((ServiceTarget)target);
            this.target = target;
            this.configurator = configurator;
            this.registrar = registrar;
            this.registry = registry;
        }

        public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<?> addService() {
            return new ConfiguredSingletonServiceBuilder(null, (org.wildfly.clustering.singleton.service.SingletonServiceBuilder)this.configurator.apply(this.target.addService()), this.registrar, this.registry);
        }

        @Deprecated
        public org.wildfly.clustering.singleton.service.SingletonServiceBuilder<?> addService(ServiceName name) {
            return new ConfiguredSingletonServiceBuilder(name, (org.wildfly.clustering.singleton.service.SingletonServiceBuilder)this.configurator.apply(this.target.addService(name)), this.registrar, this.registry);
        }

        @Deprecated
        public <T> org.wildfly.clustering.singleton.service.SingletonServiceBuilder<T> addService(ServiceName name, org.jboss.msc.service.Service<T> service) {
            org.wildfly.clustering.singleton.service.SingletonServiceBuilder builder = this.target.addService(name, service);
            this.configurator.apply(builder);
            return new ConfiguredSingletonServiceBuilder(name, builder, this.registrar, this.registry);
        }

        public SingletonServiceTarget subTarget() {
            return new ConfiguredSingletonServiceTarget(this.target.subTarget(), this.configurator, this.registrar, this.registry);
        }
    }
}

