/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.log4j;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.jboss.logmanager.MDC;

public class ThreadContextMDCMap
implements ThreadContextMap {
    private static final MethodHandle IS_EMPTY;

    public void clear() {
        MDC.clear();
    }

    public boolean containsKey(String key) {
        return MDC.get((String)key) != null;
    }

    public String get(String key) {
        return MDC.get((String)key);
    }

    public Map<String, String> getCopy() {
        return MDC.copy();
    }

    public Map<String, String> getImmutableMapOrNull() {
        Map copy = MDC.copy();
        return copy.isEmpty() ? null : Map.copyOf(copy);
    }

    public boolean isEmpty() {
        if (IS_EMPTY != null) {
            try {
                return IS_EMPTY.invoke();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return MDC.copy().isEmpty();
    }

    public void put(String key, String value) {
        if (value == null) {
            MDC.remove((String)key);
        } else {
            MDC.put((String)key, (String)value);
        }
    }

    public void remove(String key) {
        MDC.remove((String)key);
    }

    static {
        MethodHandle handle = null;
        try {
            handle = MethodHandles.publicLookup().findStatic(MDC.class, "isEmpty", MethodType.methodType(Boolean.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        IS_EMPTY = handle;
    }
}

