/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.async;

import io.smallrye.faulttolerance.core.Completer;
import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.async.AsyncLogger;
import io.smallrye.faulttolerance.core.async.ThreadOffloadEnabled;
import io.smallrye.faulttolerance.core.util.Preconditions;
import java.util.concurrent.Executor;

public class ThreadOffload<V>
implements FaultToleranceStrategy<V> {
    private final FaultToleranceStrategy<V> delegate;
    private final Executor executor;
    private final ThreadOffloadEnabled defaultEnabled;

    public ThreadOffload(FaultToleranceStrategy<V> delegate, Executor executor, boolean defaultEnabled) {
        this.delegate = delegate;
        this.executor = Preconditions.checkNotNull(executor, "Executor must be set");
        this.defaultEnabled = new ThreadOffloadEnabled(defaultEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<V> apply(FaultToleranceContext<V> ctx) {
        if (!ctx.get(ThreadOffloadEnabled.class, this.defaultEnabled).value) {
            return this.delegate.apply(ctx);
        }
        AsyncLogger.LOG.trace("ThreadOffload started");
        try {
            Executor executor = ctx.get(Executor.class, this.executor);
            Completer result = Completer.create();
            executor.execute(() -> {
                try {
                    this.delegate.apply(ctx).thenComplete(result);
                }
                catch (Exception e) {
                    result.completeWithError(e);
                }
            });
            Future future = result.future();
            return future;
        }
        finally {
            AsyncLogger.LOG.trace("ThreadOffload finished");
        }
    }
}

