/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.impl;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurationContext;
import org.hibernate.search.backend.lucene.analysis.LuceneAnalysisConfigurer;

public final class LuceneDefaultAnalysisConfigurer
implements LuceneAnalysisConfigurer {
    public static final LuceneDefaultAnalysisConfigurer INSTANCE = new LuceneDefaultAnalysisConfigurer();
    private final Analyzer standard = new StandardAnalyzer();
    private final Analyzer simple = new SimpleAnalyzer();
    private final Analyzer whitespace = new WhitespaceAnalyzer();
    private final Analyzer stop = new StopAnalyzer(EnglishAnalyzer.ENGLISH_STOP_WORDS_SET);
    private final Analyzer keyword = new KeywordAnalyzer();

    private LuceneDefaultAnalysisConfigurer() {
    }

    @Override
    public void configure(LuceneAnalysisConfigurationContext context) {
        context.analyzer("default").instance(this.standard);
        context.analyzer("standard").instance(this.standard);
        context.analyzer("simple").instance(this.simple);
        context.analyzer("whitespace").instance(this.whitespace);
        context.analyzer("stop").instance(this.stop);
        context.analyzer("keyword").instance(this.keyword);
    }
}

