/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye;

import java.util.HashMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.microprofile.config.smallrye.ConfigSourceDefinition;
import org.wildfly.extension.microprofile.config.smallrye.MicroProfileConfigExtension;

public class MicroProfileConfigTransformers
implements ExtensionTransformerRegistration {
    public String getSubsystemName() {
        return "microprofile-config-smallrye";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        this.registerTransformers_WildFly_26(builder.createBuilder(MicroProfileConfigExtension.VERSION_2_0_0, MicroProfileConfigExtension.VERSION_1_1_0));
        builder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{MicroProfileConfigExtension.VERSION_1_1_0}});
    }

    private void registerTransformers_WildFly_26(ResourceTransformationDescriptionBuilder builder) {
        HashMap<String, 1> checkers = new HashMap<String, 1>();
        checkers.put(ConfigSourceDefinition.ROOT.getName(), new RejectAttributeChecker.SimpleAcceptAttributeChecker(ModelNode.FALSE){

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (!attributeValue.hasDefined(ConfigSourceDefinition.ROOT.getName())) {
                    return false;
                }
                return super.rejectAttribute(address, attributeName, attributeValue, context);
            }
        });
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource(MicroProfileConfigExtension.CONFIG_SOURCE_PATH).getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.ObjectFieldsRejectAttributeChecker(checkers), new AttributeDefinition[]{ConfigSourceDefinition.DIR})).setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

            protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                if (attributeValue.hasDefined(ConfigSourceDefinition.ROOT.getName())) {
                    attributeValue.remove(ConfigSourceDefinition.ROOT.getName());
                }
            }
        }, new AttributeDefinition[]{ConfigSourceDefinition.DIR});
    }
}

