/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.LinkedList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.DefaultSubsystemDescribeHandler;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.SubsystemRegistration;
import org.jboss.as.clustering.controller.SubsystemResourceDefinition;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsServiceInstaller;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.XMLAttribute;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jgroups.JChannel;
import org.jgroups.Version;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.DefaultChannelServiceInstallerProvider;
import org.wildfly.clustering.server.service.LegacyClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.ProvidedUnaryServiceInstallerProvider;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class JGroupsSubsystemResourceDefinition
extends SubsystemResourceDefinition
implements ResourceServiceConfigurator {
    public static final PathElement PATH = JGroupsSubsystemResourceDefinition.pathElement((String)"jgroups");
    static final NullaryServiceDescriptor<JChannel> DEFAULT_CHANNEL = NullaryServiceDescriptor.of((String)"org.wildfly.clustering.jgroups.default-channel", JChannel.class);
    static final NullaryServiceDescriptor<Module> DEFAULT_CHANNEL_MODULE = NullaryServiceDescriptor.of((String)"org.wildfly.clustering.jgroups.default-channel-module", Module.class);
    static final NullaryServiceDescriptor<ChannelFactory> DEFAULT_CHANNEL_SOURCE = NullaryServiceDescriptor.of((String)"org.wildfly.clustering.jgroups.default-channel-source", ChannelFactory.class);
    static final NullaryServiceDescriptor<String> DEFAULT_CHANNEL_CLUSTER = NullaryServiceDescriptor.of((String)"org.wildfly.clustering.jgroups.default-channel-cluster", String.class);
    private static final RuntimeCapability<Void> DEFAULT_CHANNEL_FACTORY_CAPABILITY = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ChannelFactory.DEFAULT_SERVICE_DESCRIPTOR).build();
    private static final RuntimeCapability<Void> DEFAULT_CHANNEL_CAPABILITY = RuntimeCapability.Builder.of(DEFAULT_CHANNEL).build();
    private static final RuntimeCapability<Void> DEFAULT_CHANNEL_MODULE_CAPABILITY = RuntimeCapability.Builder.of(DEFAULT_CHANNEL_MODULE).build();
    private static final RuntimeCapability<Void> DEFAULT_CHANNEL_SOURCE_CAPABILITY = RuntimeCapability.Builder.of(DEFAULT_CHANNEL_SOURCE).build();
    private static final RuntimeCapability<Void> DEFAULT_CHANNEL_CLUSTER_CAPABILITY = RuntimeCapability.Builder.of(DEFAULT_CHANNEL_CLUSTER).build();

    JGroupsSubsystemResourceDefinition() {
        super(PATH, (ResourceDescriptionResolver)JGroupsExtension.SUBSYSTEM_RESOLVER);
    }

    public void register(SubsystemRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubsystemModel((ResourceDefinition)this);
        new DefaultSubsystemDescribeHandler().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        RuntimeCapability defaultCommandDispatcherFactory = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ClusteringServiceDescriptor.DEFAULT_COMMAND_DISPATCHER_FACTORY).setAllowMultipleRegistrations(true).build();
        RuntimeCapability defaultLegacyCommandDispatcherFactory = RuntimeCapability.Builder.of((NullaryServiceDescriptor)LegacyClusteringServiceDescriptor.DEFAULT_COMMAND_DISPATCHER_FACTORY).setAllowMultipleRegistrations(true).build();
        RuntimeCapability defaultGroup = RuntimeCapability.Builder.of((NullaryServiceDescriptor)ClusteringServiceDescriptor.DEFAULT_GROUP).setAllowMultipleRegistrations(true).build();
        RuntimeCapability defaultLegacyGroup = RuntimeCapability.Builder.of((NullaryServiceDescriptor)LegacyClusteringServiceDescriptor.DEFAULT_GROUP).setAllowMultipleRegistrations(true).build();
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(model -> model.hasDefined(Attribute.DEFAULT_CHANNEL.getName()), List.of(DEFAULT_CHANNEL_CAPABILITY, DEFAULT_CHANNEL_FACTORY_CAPABILITY, DEFAULT_CHANNEL_MODULE_CAPABILITY, DEFAULT_CHANNEL_SOURCE_CAPABILITY, DEFAULT_CHANNEL_CLUSTER_CAPABILITY, defaultCommandDispatcherFactory, defaultLegacyCommandDispatcherFactory, defaultGroup, defaultLegacyGroup));
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        new ChannelResourceDefinition().register(registration);
        new StackResourceDefinition().register(registration);
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        JGroupsLogger.ROOT_LOGGER.activatingSubsystem(Version.printVersion());
        PathAddress address = context.getCurrentAddress();
        if (context.getProcessType().isServer() && !context.isBooting() && context.readResourceFromRoot(address.getParent(), false).hasChild(PathElement.pathElement((String)"subsystem", (String)"infinispan"))) {
            context.addStep((ctx, operation) -> {
                ctx.reloadRequired();
                ctx.completeStep(OperationContext.RollbackHandler.REVERT_RELOAD_REQUIRED_ROLLBACK_HANDLER);
            }, OperationContext.Stage.RUNTIME);
            return ResourceServiceInstaller.combine((ResourceServiceInstaller[])new ResourceServiceInstaller[0]);
        }
        LinkedList<ProtocolDefaultsServiceInstaller> installers = new LinkedList<ProtocolDefaultsServiceInstaller>();
        installers.add(new ProtocolDefaultsServiceInstaller());
        String defaultChannel = Attribute.DEFAULT_CHANNEL.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        if (defaultChannel != null) {
            installers.add((ProtocolDefaultsServiceInstaller)((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_CHANNEL_CAPABILITY, (ServiceDependency)ServiceDependency.on(ChannelResourceDefinition.CHANNEL, (String)defaultChannel)).build()));
            installers.add((ProtocolDefaultsServiceInstaller)((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_CHANNEL_FACTORY_CAPABILITY, (ServiceDependency)ServiceDependency.on((UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR, (String)defaultChannel)).build()));
            installers.add((ProtocolDefaultsServiceInstaller)((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_CHANNEL_MODULE_CAPABILITY, (ServiceDependency)ServiceDependency.on(ChannelResourceDefinition.CHANNEL_MODULE, (String)defaultChannel)).build()));
            installers.add((ProtocolDefaultsServiceInstaller)((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_CHANNEL_SOURCE_CAPABILITY, (ServiceDependency)ServiceDependency.on(ChannelResourceDefinition.CHANNEL_SOURCE, (String)defaultChannel)).build()));
            installers.add((ProtocolDefaultsServiceInstaller)((ResourceServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_CHANNEL_CLUSTER_CAPABILITY, (ServiceDependency)ServiceDependency.on(ChannelResourceDefinition.CHANNEL_CLUSTER, (String)defaultChannel)).build()));
            if (!defaultChannel.equals("default")) {
                installers.add((ProtocolDefaultsServiceInstaller)new BinderServiceInstaller(JGroupsBindingFactory.createChannelBinding("default"), DEFAULT_CHANNEL_CAPABILITY.getCapabilityServiceName()));
                installers.add((ProtocolDefaultsServiceInstaller)new BinderServiceInstaller(JGroupsBindingFactory.createChannelFactoryBinding("default"), DEFAULT_CHANNEL_FACTORY_CAPABILITY.getCapabilityServiceName()));
            }
            new ProvidedUnaryServiceInstallerProvider(DefaultChannelServiceInstallerProvider.class, DefaultChannelServiceInstallerProvider.class.getClassLoader()).apply(context.getCapabilityServiceSupport(), defaultChannel).forEach(installers::add);
        }
        return ResourceServiceInstaller.combine(installers);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        DEFAULT_CHANNEL("default-channel", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(DEFAULT_CHANNEL_FACTORY_CAPABILITY, (UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR).build());
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setRequired(false)).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setXmlName(XMLAttribute.DEFAULT.getLocalName()))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

