/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.search.mapper.common.impl;

import java.util.Objects;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public class EntityReferenceImpl
implements EntityReference {
    private final PojoRawTypeIdentifier<?> typeIdentifier;
    private final String name;
    private final Object id;

    public static EntityReference withDefaultName(Class<?> type, Object id) {
        return new EntityReferenceImpl(PojoRawTypeIdentifier.of(type), type.getSimpleName(), id);
    }

    public EntityReferenceImpl(PojoRawTypeIdentifier<?> typeIdentifier, String name, Object id) {
        this.typeIdentifier = typeIdentifier;
        this.name = name;
        this.id = id;
    }

    public Class<?> type() {
        return this.typeIdentifier.javaClass();
    }

    public String name() {
        return this.name;
    }

    public Object id() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EntityReferenceImpl other = (EntityReferenceImpl)obj;
        return this.name.equals(other.name) && Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id);
    }

    public String toString() {
        return this.name + "#" + String.valueOf(this.id);
    }
}

