/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.Reflect;

public class EnumMapMarshaller<E extends Enum<E>>
implements ProtoStreamMarshaller<EnumMap<E, Object>> {
    static final Field ENUM_MAP_KEY_CLASS_FIELD = Reflect.findField(EnumMap.class, Class.class);
    private static final int CLASS_INDEX = 1;
    private static final int ELEMENT_INDEX = 2;

    @Override
    public EnumMap<E, Object> readFrom(ProtoStreamReader reader) throws IOException {
        Class enumClass = null;
        LinkedList<Object> elements = new LinkedList<Object>();
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    enumClass = reader.readObject(Class.class);
                    continue block4;
                }
                case 2: {
                    elements.add(reader.readAny());
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        EnumMap<Enum, Object> map = new EnumMap<Enum, Object>(enumClass);
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        ListIterator iterator = elements.listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            Object element = iterator.next();
            if (element == null) continue;
            map.put(values[index], element == Any.NULL ? null : (Object)element);
        }
        return map;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, EnumMap<E, Object> map) throws IOException {
        Class<E> enumClass = this.findEnumClass(map);
        writer.writeObject(1, enumClass);
        for (Enum key : EnumSet.allOf(enumClass)) {
            if (!map.containsKey(key)) continue;
            Object value = map.get(key);
            writer.writeAny(2, value == null ? Any.NULL : value);
        }
    }

    @Override
    public Class<? extends EnumMap<E, Object>> getJavaClass() {
        return EnumMap.class;
    }

    private Class<E> findEnumClass(EnumMap<E, Object> map) {
        Iterator<E> values = map.keySet().iterator();
        if (values.hasNext()) {
            return ((Enum)values.next()).getDeclaringClass();
        }
        return Reflect.getValue(map, ENUM_MAP_KEY_CLASS_FIELD, Class.class);
    }
}

