/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class StringKeyMapEntryMarshaller<T extends Map.Entry<String, Object>>
implements ProtoStreamMarshaller<T> {
    private static final int KEY_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private final Class<? extends T> targetClass;
    private final BiFunction<String, Object, T> factory;

    public StringKeyMapEntryMarshaller(BiFunction<String, Object, T> factory) {
        this.targetClass = ((Map.Entry)factory.apply(null, null)).getClass();
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        String key = null;
        Object value = null;
        block4: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            switch (index) {
                case 1: {
                    key = reader.readString();
                    continue block4;
                }
                case 2: {
                    value = reader.readAny();
                    continue block4;
                }
            }
            reader.skipField(tag);
        }
        return (T)((Map.Entry)this.factory.apply(key, value));
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T entry) throws IOException {
        Object value;
        String key = (String)entry.getKey();
        if (key != null) {
            writer.writeString(1, key);
        }
        if ((value = entry.getValue()) != null) {
            writer.writeAny(2, value);
        }
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

