/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.subsystem.service.ResourceServiceInstaller;

public interface ResourceServiceConfigurator {
    public ResourceServiceInstaller configure(OperationContext var1, ModelNode var2) throws OperationFailedException;

    public static ResourceServiceConfigurator combine(ResourceServiceConfigurator ... configurators) {
        return ResourceServiceConfigurator.combine(List.of(configurators));
    }

    public static ResourceServiceConfigurator combine(final Collection<? extends ResourceServiceConfigurator> configurators) {
        return new ResourceServiceConfigurator(){

            @Override
            public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
                ArrayList<ResourceServiceInstaller> installers = new ArrayList<ResourceServiceInstaller>(configurators.size());
                for (ResourceServiceConfigurator configurator : configurators) {
                    installers.add(configurator.configure(context, model));
                }
                return ResourceServiceInstaller.combine(installers);
            }
        };
    }
}

