/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.threads.InterruptHandler;
import org.jboss.threads.Messages;
import org.jboss.threads.StoppedExecutorException;

public class Messages_$logger
extends DelegatingBasicLogger
implements Messages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Messages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void version(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, (Throwable)null, this.version$str(), (Object)version);
    }

    protected String version$str() {
        return "JBoss Threads version %s";
    }

    protected String operationTimedOut$str() {
        return "JBTHR00003: Operation timed out";
    }

    @Override
    public final TimeoutException operationTimedOut() {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.operationTimedOut$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String operationCancelled$str() {
        return "JBTHR00004: Operation was cancelled";
    }

    @Override
    public final CancellationException operationCancelled() {
        CancellationException result = new CancellationException(String.format(this.getLoggingLocale(), this.operationCancelled$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationFailed$str() {
        return "JBTHR00005: Operation failed";
    }

    @Override
    public final ExecutionException operationFailed(Throwable cause) {
        ExecutionException result = new ExecutionException(String.format(this.getLoggingLocale(), this.operationFailed$str(), new Object[0]), cause);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String shutDownInitiated$str() {
        return "JBTHR00009: Executor has been shut down";
    }

    @Override
    public final StoppedExecutorException shutDownInitiated() {
        StoppedExecutorException result = new StoppedExecutorException(String.format(this.getLoggingLocale(), this.shutDownInitiated$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAwaitWithin$str() {
        return "JBTHR00012: Cannot await termination of a thread pool from one of its own threads";
    }

    @Override
    public final IllegalStateException cannotAwaitWithin() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotAwaitWithin$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noInterruptHandlers$str() {
        return "JBTHR00103: The current thread does not support interrupt handlers";
    }

    @Override
    public final IllegalStateException noInterruptHandlers() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noInterruptHandlers$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void interruptHandlerThrew(Throwable cause, InterruptHandler interruptHandler) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.interruptHandlerThrew$str(), (Object)interruptHandler);
    }

    protected String interruptHandlerThrew$str() {
        return "JBTHR00108: Interrupt handler %s threw an exception";
    }

    protected String nonPositiveKeepAlive$str() {
        return "JBTHR00109: Keep-alive time must be positive but was %s";
    }

    @Override
    public final IllegalArgumentException nonPositiveKeepAlive(Duration actual) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nonPositiveKeepAlive$str(), actual));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAllowedContainerManaged$str() {
        return "JBTHR00200: %s() not allowed on container-managed executor";
    }

    @Override
    public final SecurityException notAllowedContainerManaged(String methodName) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.notAllowedContainerManaged$str(), methodName));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

