/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import io.netty.channel.Channel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import javax.management.ObjectName;
import org.infinispan.api.async.AsyncCacheEntryProcessor;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.events.cache.CacheEntryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;
import org.infinispan.api.common.process.CacheEntryProcessorResult;
import org.infinispan.api.common.process.CacheProcessorOptions;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSet;

public interface InternalRemoteCache<K, V>
extends RemoteCache<K, V> {
    public byte[] getNameBytes();

    public CloseableIterator<K> keyIterator(IntSet var1);

    public CloseableIterator<Map.Entry<K, V>> entryIterator(IntSet var1);

    default public boolean removeEntry(Map.Entry<K, V> entry) {
        return this.removeEntry(entry.getKey(), entry.getValue());
    }

    default public boolean removeEntry(K key, V value) {
        MetadataValue versionedValue = this.getWithMetadata(key);
        return versionedValue != null && value.equals(versionedValue.getValue()) && this.removeWithVersion(key, versionedValue.getVersion());
    }

    public CompletionStage<GetWithMetadataOperation.GetWithMetadataResult<V>> getWithMetadataAsync(K var1, Channel var2);

    @Override
    public InternalRemoteCache<K, V> withFlags(Flag ... var1);

    @Override
    public InternalRemoteCache<K, V> noFlags();

    public int flagInt();

    @Override
    public <T, U> InternalRemoteCache<T, U> withDataFormat(DataFormat var1);

    public boolean hasForceReturnFlag();

    public void resolveStorage();

    default public void resolveStorage(MediaType key, MediaType value) {
        this.resolveStorage();
    }

    @Override
    public ClientStatistics clientStatistics();

    public void init(Configuration var1, OperationDispatcher var2);

    public void init(Configuration var1, OperationDispatcher var2, ObjectName var3);

    public OperationDispatcher getDispatcher();

    public byte[] keyToBytes(Object var1);

    public CompletionStage<PingResponse> ping();

    public Channel addNearCacheListener(Object var1, int var2);

    public CompletionStage<Void> updateBloomFilter();

    public CacheOperationsFactory getOperationsFactory();

    public ClientListenerNotifier getListenerNotifier();

    public CompletionStage<CacheConfiguration> configuration();

    public CompletionStage<V> get(K var1, CacheOptions var2);

    public CompletionStage<CacheEntry<K, V>> getEntry(K var1, CacheOptions var2);

    public CompletionStage<CacheEntry<K, V>> putIfAbsent(K var1, V var2, CacheWriteOptions var3);

    public CompletionStage<Boolean> setIfAbsent(K var1, V var2, CacheWriteOptions var3);

    public CompletionStage<CacheEntry<K, V>> put(K var1, V var2, CacheWriteOptions var3);

    public CompletionStage<Void> set(K var1, V var2, CacheWriteOptions var3);

    public CompletionStage<Boolean> replace(K var1, V var2, CacheEntryVersion var3, CacheWriteOptions var4);

    public CompletionStage<CacheEntry<K, V>> getOrReplaceEntry(K var1, V var2, CacheEntryVersion var3, CacheWriteOptions var4);

    public CompletionStage<Boolean> remove(K var1, CacheOptions var2);

    public CompletionStage<Boolean> remove(K var1, CacheEntryVersion var2, CacheOptions var3);

    public CompletionStage<CacheEntry<K, V>> getAndRemove(K var1, CacheOptions var2);

    public Flow.Publisher<K> keys(CacheOptions var1);

    public Flow.Publisher<CacheEntry<K, V>> entries(CacheOptions var1);

    public CompletionStage<Void> putAll(Map<K, V> var1, CacheWriteOptions var2);

    public CompletionStage<Void> putAll(Flow.Publisher<CacheEntry<K, V>> var1, CacheWriteOptions var2);

    public Flow.Publisher<CacheEntry<K, V>> getAll(Set<K> var1, CacheOptions var2);

    public Flow.Publisher<CacheEntry<K, V>> getAll(CacheOptions var1, K[] var2);

    public Flow.Publisher<K> removeAll(Set<K> var1, CacheWriteOptions var2);

    public Flow.Publisher<K> removeAll(Flow.Publisher<K> var1, CacheWriteOptions var2);

    public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Set<K> var1, CacheWriteOptions var2);

    public Flow.Publisher<CacheEntry<K, V>> getAndRemoveAll(Flow.Publisher<K> var1, CacheWriteOptions var2);

    public CompletionStage<Long> estimateSize(CacheOptions var1);

    public CompletionStage<Void> clear(CacheOptions var1);

    public Flow.Publisher<CacheEntryEvent<K, V>> listen(CacheListenerOptions var1, CacheEntryEventType[] var2);

    public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> process(Set<K> var1, AsyncCacheEntryProcessor<K, V, T> var2, CacheOptions var3);

    public <T> Flow.Publisher<CacheEntryProcessorResult<K, T>> processAll(AsyncCacheEntryProcessor<K, V, T> var1, CacheProcessorOptions var2);
}

