/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.function.Function;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.CacheConfigurationAttributeGroup;
import org.wildfly.clustering.web.service.user.DistributableUserManagementProvider;
import org.wildfly.extension.clustering.web.DistributableWebSubsystemResourceDefinitionRegistrar;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public abstract class UserManagementResourceDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator,
Function<BinaryServiceConfiguration, DistributableUserManagementProvider> {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)DistributableUserManagementProvider.SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).build();
    private final ResourceRegistration registration;
    private final CacheConfigurationAttributeGroup cacheAttributeGroup;

    UserManagementResourceDefinitionRegistrar(ResourceRegistration registration, CacheConfigurationAttributeGroup cacheAttributeGroup) {
        this.registration = registration;
        this.cacheAttributeGroup = cacheAttributeGroup;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ParentResourceDescriptionResolver resolver = DistributableWebSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(this.registration.getPathElement());
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)resolver).addAttributes(this.cacheAttributeGroup.getAttributes())).addCapability(CAPABILITY)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)this.registration, (ResourceDescriptionResolver)descriptor.getResourceDescriptionResolver()).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        BinaryServiceConfiguration configuration = this.cacheAttributeGroup.resolve(context, model);
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(CAPABILITY, (Object)((DistributableUserManagementProvider)this.apply(configuration))).build();
    }
}

