/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.NullAddress;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.logging.Log;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.MsgStats;
import org.jgroups.protocols.TP;
import org.jgroups.stack.MessageProcessingPolicy;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.FastArray;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@Experimental
public class PerDestinationBundler
implements Bundler {
    @Property(name="max_size", type=AttributeType.BYTES, description="Maximum number of bytes for messages to be queued (per destination) until they are sent")
    protected int max_size = 64000;
    @ManagedAttribute(description="Total number of messages sent (single and batches)", type=AttributeType.SCALAR)
    protected final LongAdder total_msgs_sent = new LongAdder();
    @ManagedAttribute(description="Number of single messages sent", type=AttributeType.SCALAR)
    protected final LongAdder num_single_msgs_sent = new LongAdder();
    @ManagedAttribute(description="Number of batches sent", type=AttributeType.SCALAR)
    protected final LongAdder num_batches_sent = new LongAdder();
    @ManagedAttribute(description="Number of batches sent because no more messages were available", type=AttributeType.SCALAR)
    protected final LongAdder num_send_due_to_no_msgs = new LongAdder();
    @ManagedAttribute(description="Number of batches sent because the queue was full", type=AttributeType.SCALAR)
    protected final LongAdder num_sends_due_to_max_size = new LongAdder();
    @ManagedAttribute(description="Times to send messages")
    protected final AverageMinMax send_times = (AverageMinMax)new AverageMinMax().unit(TimeUnit.NANOSECONDS);
    protected TP transport;
    protected MsgStats msg_stats;
    protected MessageProcessingPolicy msg_processing_policy;
    protected Log log;
    protected Address local_addr;
    protected final Map<Address, SendBuffer> dests = Util.createConcurrentMap();
    protected static final Address NULL = new NullAddress();
    protected static final String THREAD_NAME = "pd-bundler";

    @Override
    public int size() {
        return this.dests.values().stream().map(SendBuffer::size).reduce(0, Integer::sum);
    }

    @Override
    public int getQueueSize() {
        return -1;
    }

    @Override
    public int getMaxSize() {
        return this.max_size;
    }

    @Override
    public Bundler setMaxSize(int s) {
        this.max_size = s;
        return this;
    }

    @ManagedAttribute(description="Average number of messages in an BatchMessage")
    public double avgBatchSize() {
        long num_batches = this.num_batches_sent.sum();
        long total_msgs = this.total_msgs_sent.sum();
        long single_msgs = this.num_single_msgs_sent.sum();
        if (num_batches == 0L || total_msgs == 0L) {
            return 0.0;
        }
        long batched_msgs = total_msgs - single_msgs;
        return (double)batched_msgs / (double)num_batches;
    }

    @Override
    public void resetStats() {
        Stream.of(this.total_msgs_sent, this.num_batches_sent, this.num_single_msgs_sent, this.num_sends_due_to_max_size).forEach(LongAdder::reset);
        this.send_times.clear();
    }

    @Override
    public void init(TP transport) {
        this.transport = Objects.requireNonNull(transport);
        this.msg_processing_policy = transport.msgProcessingPolicy();
        this.msg_stats = transport.getMessageStats();
        this.log = transport.getLog();
    }

    @Override
    public void start() {
        this.local_addr = Objects.requireNonNull(this.transport.getAddress());
        this.dests.values().forEach(SendBuffer::start);
    }

    @Override
    public void stop() {
        this.dests.values().forEach(SendBuffer::stop);
    }

    @Override
    public void send(Message msg) throws Exception {
        Address dest;
        SendBuffer buf;
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
        if ((buf = this.dests.get(dest = msg.dest() == null ? NULL : msg.dest())) == null) {
            buf = this.dests.computeIfAbsent(dest, k -> new SendBuffer(dest).start());
        }
        buf.send(msg);
    }

    @Override
    public void viewChange(View view) {
        List<Address> mbrs = view.getMembers();
        if (mbrs == null) {
            return;
        }
        mbrs.stream().filter(dest -> !this.dests.containsKey(dest)).forEach(dest -> this.dests.putIfAbsent((Address)dest, new SendBuffer((Address)dest).start()));
        this.dests.keySet().stream().filter(dest -> !mbrs.contains(dest) && dest != NULL).forEach(this.dests::remove);
    }

    protected class SendBuffer
    implements Runnable {
        private final Address dest;
        protected final FastArray<Message> msgs = new FastArray(16);
        private final Lock lock = new ReentrantLock(false);
        private final BlockingQueue<Message> queue = new ArrayBlockingQueue<Message>(8192);
        private final List<Message> remove_queue = new ArrayList<Message>(1024);
        private final ByteArrayDataOutputStream output;
        private volatile Thread bundler_thread;
        private volatile boolean running;
        private long count;

        protected SendBuffer(Address dest) {
            this.output = new ByteArrayDataOutputStream(PerDestinationBundler.this.max_size + 5);
            this.running = true;
            this.dest = dest;
        }

        public SendBuffer start() {
            if (this.running) {
                this.stop();
            }
            this.bundler_thread = PerDestinationBundler.this.transport.getThreadFactory().newThread(this, PerDestinationBundler.THREAD_NAME);
            this.running = true;
            this.bundler_thread.start();
            return this;
        }

        public void stop() {
            this.running = false;
            Thread tmp = this.bundler_thread;
            if (tmp != null) {
                tmp.interrupt();
            }
        }

        @Override
        public void run() {
            while (this.running) {
                Message msg = null;
                try {
                    msg = this.queue.take();
                    if (msg == null) continue;
                    this.addAndSendIfSizeExceeded(msg);
                    block3: while (true) {
                        this.remove_queue.clear();
                        int num_msgs = this.queue.drainTo(this.remove_queue);
                        if (num_msgs <= 0) break;
                        int i = 0;
                        while (true) {
                            if (i >= this.remove_queue.size()) continue block3;
                            msg = this.remove_queue.get(i);
                            this.addAndSendIfSizeExceeded(msg);
                            ++i;
                        }
                        break;
                    }
                    if (this.count <= 0L) continue;
                    this.sendBundledMessages();
                    PerDestinationBundler.this.num_send_due_to_no_msgs.increment();
                }
                catch (Throwable throwable) {}
            }
        }

        protected void addAndSendIfSizeExceeded(Message msg) {
            int size = msg.size();
            if (this.count + (long)size >= (long)PerDestinationBundler.this.max_size) {
                this.sendBundledMessages();
                PerDestinationBundler.this.num_sends_due_to_max_size.increment();
            }
            this.addMessage(msg, size);
        }

        protected void addMessage(Message msg, int size) {
            this.msgs.add(msg);
            this.count += (long)size;
        }

        protected void send(Message msg) throws Exception {
            this.queue.put(msg);
        }

        protected void sendBundledMessages() {
            if (this.msgs.isEmpty()) {
                return;
            }
            Address dst = this.dest == NULL ? null : this.dest;
            this.sendMessages(dst, PerDestinationBundler.this.local_addr, this.msgs);
            this.msgs.clear(false);
            this.count = 0L;
        }

        protected void sendMessages(Address dest, Address src, FastArray<Message> list) {
            long start = PerDestinationBundler.this.transport.statsEnabled() ? System.nanoTime() : 0L;
            try {
                int size = list.size();
                if (size == 0) {
                    return;
                }
                if (size == 1) {
                    this.sendSingle(dest, list.get(0), this.output);
                } else {
                    this.sendMultiple(dest, src, list, this.output);
                }
                if (start > 0L) {
                    PerDestinationBundler.this.send_times.add(System.nanoTime() - start);
                }
                PerDestinationBundler.this.total_msgs_sent.add(size);
            }
            catch (Throwable e) {
                PerDestinationBundler.this.log.trace(Util.getMessage("FailureSendingMsgBundle"), PerDestinationBundler.this.transport.getAddress(), e);
            }
        }

        protected void sendSingle(Address dst, Message msg, ByteArrayDataOutputStream out) {
            if (dst == null) {
                this.sendSingleMessage(msg.dest(), msg, out);
                this.loopbackUnlessDontLoopbackIsSet(msg);
            } else {
                boolean send_to_self;
                boolean bl = send_to_self = Objects.equals(PerDestinationBundler.this.transport.getAddress(), dst) || dst instanceof PhysicalAddress && dst.equals(PerDestinationBundler.this.transport.localPhysicalAddress());
                if (send_to_self) {
                    this.loopbackUnlessDontLoopbackIsSet(msg);
                } else {
                    this.sendSingleMessage(msg.dest(), msg, out);
                }
            }
        }

        protected void sendMultiple(Address dst, Address sender, FastArray<Message> list, ByteArrayDataOutputStream out) {
            if (dst == null) {
                this.sendMessageList(dst, sender, list, out);
                this.loopback(dst, PerDestinationBundler.this.transport.getAddress(), list);
            } else {
                boolean loopback;
                boolean bl = loopback = Objects.equals(PerDestinationBundler.this.transport.getAddress(), dst) || dst instanceof PhysicalAddress && dst.equals(PerDestinationBundler.this.transport.localPhysicalAddress());
                if (loopback) {
                    this.loopback(dst, PerDestinationBundler.this.transport.getAddress(), list);
                } else {
                    this.sendMessageList(dst, sender, list, out);
                }
            }
        }

        protected void sendSingleMessage(Address dest, Message msg, ByteArrayDataOutputStream out) {
            try {
                out.position(0);
                Util.writeMessage(msg, out, dest == null);
                PerDestinationBundler.this.transport.doSend(out.buffer(), 0, out.position(), dest);
                PerDestinationBundler.this.transport.getMessageStats().incrNumSingleMsgsSent();
                PerDestinationBundler.this.num_single_msgs_sent.increment();
            }
            catch (Throwable e) {
                PerDestinationBundler.this.log.error("%s: failed sending message to %s: %s", PerDestinationBundler.this.local_addr, dest, e);
            }
        }

        protected void sendMessageList(Address dest, Address src, FastArray<Message> list, ByteArrayDataOutputStream out) {
            out.position(0);
            try {
                Util.writeMessageList(dest, src, PerDestinationBundler.this.transport.cluster_name.chars(), list, (DataOutput)out, dest == null);
                PerDestinationBundler.this.transport.doSend(out.buffer(), 0, out.position(), dest);
                PerDestinationBundler.this.transport.getMessageStats().incrNumBatchesSent();
                PerDestinationBundler.this.num_batches_sent.increment();
            }
            catch (Throwable e) {
                PerDestinationBundler.this.log.trace(Util.getMessage("FailureSendingMsgBundle"), PerDestinationBundler.this.transport.getAddress(), e);
            }
        }

        protected void loopback(Address dest, Address sender, FastArray<Message> list) {
            MessageBatch reg = null;
            MessageBatch oob = null;
            for (Message msg : list) {
                if (msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) continue;
                if (msg.isFlagSet(Message.Flag.OOB)) {
                    if (oob == null) {
                        oob = new MessageBatch(dest, sender, PerDestinationBundler.this.transport.getClusterNameAscii(), dest == null, MessageBatch.Mode.OOB, list.size());
                    }
                    oob.add(msg);
                    continue;
                }
                if (reg == null) {
                    reg = new MessageBatch(dest, sender, PerDestinationBundler.this.transport.getClusterNameAscii(), dest == null, MessageBatch.Mode.REG, list.size());
                }
                reg.add(msg);
            }
            if (reg != null) {
                PerDestinationBundler.this.msg_stats.received(reg);
                PerDestinationBundler.this.msg_processing_policy.loopback(reg, false);
            }
            if (oob != null) {
                PerDestinationBundler.this.msg_stats.received(oob);
                PerDestinationBundler.this.msg_processing_policy.loopback(oob, true);
            }
        }

        protected void loopbackUnlessDontLoopbackIsSet(Message msg) {
            if (msg.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
                return;
            }
            PerDestinationBundler.this.msg_stats.received(msg);
            PerDestinationBundler.this.msg_processing_policy.loopback(msg, msg.isFlagSet(Message.Flag.OOB));
        }

        public String toString() {
            return String.format("%d msgs", this.size());
        }

        protected int size() {
            this.lock.lock();
            try {
                int n = this.msgs.size();
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

