/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wscf.model.twophase.arjunacore;

import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.mw.wsas.UserActivityFactory;
import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.activity.Outcome;
import com.arjuna.mw.wsas.completionstatus.CompletionStatus;
import com.arjuna.mw.wsas.completionstatus.Success;
import com.arjuna.mw.wsas.exceptions.NoActivityException;
import com.arjuna.mw.wsas.exceptions.ProtocolViolationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wsas.status.Active;
import com.arjuna.mw.wsas.status.NoActivity;
import com.arjuna.mw.wsas.status.Status;
import com.arjuna.mw.wsas.status.Unknown;
import com.arjuna.mw.wscf.common.CoordinatorId;
import com.arjuna.mw.wscf.common.Qualifier;
import com.arjuna.mw.wscf.exceptions.BegunFailedException;
import com.arjuna.mw.wscf.exceptions.DuplicateParticipantException;
import com.arjuna.mw.wscf.exceptions.InvalidParticipantException;
import com.arjuna.mw.wscf.exceptions.NoCoordinatorException;
import com.arjuna.mw.wscf.exceptions.UnexpectedException;
import com.arjuna.mw.wscf.logging.wscfLogger;
import com.arjuna.mw.wscf.model.twophase.exceptions.DuplicateSynchronizationException;
import com.arjuna.mw.wscf.model.twophase.exceptions.InvalidSynchronizationException;
import com.arjuna.mw.wscf.model.twophase.outcomes.CoordinationOutcome;
import com.arjuna.mw.wscf.model.twophase.participants.Participant;
import com.arjuna.mw.wscf.model.twophase.participants.Synchronization;
import com.arjuna.mw.wscf.model.twophase.status.CancelOnly;
import com.arjuna.mw.wscf.model.twophase.status.Cancelled;
import com.arjuna.mw.wscf.model.twophase.status.Cancelling;
import com.arjuna.mw.wscf.model.twophase.status.Confirmed;
import com.arjuna.mw.wscf.model.twophase.status.Confirming;
import com.arjuna.mw.wscf.model.twophase.status.HeuristicCancel;
import com.arjuna.mw.wscf.model.twophase.status.HeuristicConfirm;
import com.arjuna.mw.wscf.model.twophase.status.HeuristicHazard;
import com.arjuna.mw.wscf.model.twophase.status.HeuristicMixed;
import com.arjuna.mw.wscf.model.twophase.status.Prepared;
import com.arjuna.mw.wscf.model.twophase.status.Preparing;
import com.arjuna.mwlabs.wsas.activity.ActivityHandleImple;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.ATCoordinator;
import com.arjuna.mwlabs.wscf.model.twophase.arjunacore.subordinate.SubordinateATCoordinator;
import java.util.Hashtable;

public class CoordinatorControl {
    private static Hashtable _coordinators = new Hashtable();

    public void begin() throws SystemException {
        try {
            ATCoordinator coord = new ATCoordinator();
            int status = coord.start((BasicAction)this.parentCoordinator());
            if (status != 0) {
                throw new BegunFailedException(wscfLogger.i18NLogger.get_model_twophase_arjunacore_CoordinatorControl_1() + ActionStatus.stringForm((int)status));
            }
            _coordinators.put(this.currentActivity(), coord);
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UnexpectedException(ex.toString());
        }
    }

    public Outcome complete(CompletionStatus cs) throws SystemException {
        ATCoordinator current = this.currentCoordinator();
        int outcome = cs != null && cs instanceof Success ? current.end(true) : current.cancel();
        _coordinators.remove(this.currentActivity());
        return new CoordinationOutcome(cs, switch (outcome) {
            case 4 -> 10;
            case 7 -> 11;
            case 11 -> 3;
            case 12 -> 4;
            case 13 -> 5;
            case 14 -> 6;
            default -> 8;
        });
    }

    public void suspend() throws SystemException {
    }

    public void resume() throws SystemException {
    }

    public void completed() throws SystemException {
    }

    public Outcome coordinate(CompletionStatus cs) throws WrongStateException, ProtocolViolationException, SystemException {
        return null;
    }

    public Status status() throws SystemException {
        int currentStatus = this.currentCoordinator().status();
        switch (currentStatus) {
            case 0: 
            case 8: {
                return Active.instance();
            }
            case 1: {
                return Preparing.instance();
            }
            case 2: {
                return Cancelling.instance();
            }
            case 4: {
                return Cancelled.instance();
            }
            case 3: {
                return CancelOnly.instance();
            }
            case 5: {
                return Prepared.instance();
            }
            case 6: {
                return Confirming.instance();
            }
            case 7: {
                return Confirmed.instance();
            }
            case 11: {
                return HeuristicCancel.instance();
            }
            case 12: {
                return HeuristicConfirm.instance();
            }
            case 13: {
                return HeuristicMixed.instance();
            }
            case 14: {
                return HeuristicHazard.instance();
            }
            case 16: {
                return NoActivity.instance();
            }
        }
        return Unknown.instance();
    }

    public Qualifier[] qualifiers() throws NoCoordinatorException, SystemException {
        return this.currentCoordinator().qualifiers();
    }

    public CoordinatorId identifier() throws NoCoordinatorException, SystemException {
        return this.currentCoordinator().identifier();
    }

    public void enlistParticipant(Participant act) throws WrongStateException, DuplicateParticipantException, InvalidParticipantException, NoCoordinatorException, SystemException {
        this.currentCoordinator().enlistParticipant(act);
    }

    public void delistParticipant(Participant act) throws InvalidParticipantException, NoCoordinatorException, WrongStateException, SystemException {
        this.currentCoordinator().delistParticipant(act);
    }

    public void enlistSynchronization(Synchronization act) throws WrongStateException, DuplicateSynchronizationException, InvalidSynchronizationException, NoCoordinatorException, SystemException {
        this.currentCoordinator().enlistSynchronization(act);
    }

    public void delistSynchronization(Synchronization act) throws InvalidSynchronizationException, NoCoordinatorException, WrongStateException, SystemException {
        this.currentCoordinator().delistSynchronization(act);
    }

    public void participantRolledBack(String participantId) throws NoActivityException, InvalidParticipantException, WrongStateException, SystemException {
        this.currentCoordinator().participantRolledBack(participantId);
    }

    public void participantReadOnly(String participantId) throws NoActivityException, InvalidParticipantException, SystemException {
        this.currentCoordinator().participantReadOnly(participantId);
    }

    public final ATCoordinator createSubordinate(String subordinateType) throws SystemException {
        try {
            SubordinateATCoordinator coord = new SubordinateATCoordinator(subordinateType);
            int status = coord.start(null);
            if (status != 0) {
                throw new BegunFailedException(wscfLogger.i18NLogger.get_model_twophase_arjunacore_CoordinatorControl_1() + ActionStatus.stringForm((int)status));
            }
            return coord;
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UnexpectedException(ex.toString());
        }
    }

    public final ATCoordinator currentCoordinator() throws NoCoordinatorException, SystemException {
        ATCoordinator coord = (ATCoordinator)((Object)_coordinators.get(this.currentActivity()));
        if (coord == null) {
            throw new NoCoordinatorException();
        }
        return coord;
    }

    private final ActivityHandleImple currentActivity() throws SystemException {
        try {
            ActivityHierarchy hier = UserActivityFactory.userActivity().currentActivity();
            if (hier.size() > 0) {
                return (ActivityHandleImple)hier.activity(hier.size() - 1);
            }
            return null;
        }
        catch (Exception ex) {
            wscfLogger.i18NLogger.warn_unexpectedException(ex);
            throw new SystemException(ex.toString());
        }
    }

    private final ATCoordinator parentCoordinator() throws SystemException {
        try {
            ActivityHierarchy hier = UserActivityFactory.userActivity().currentActivity();
            ActivityHandleImple parentActivity = null;
            ATCoordinator parentCoordinator = null;
            if (hier.size() > 1) {
                parentActivity = (ActivityHandleImple)hier.activity(hier.size() - 2);
                parentCoordinator = (ATCoordinator)((Object)_coordinators.get(parentActivity));
            }
            return parentCoordinator;
        }
        catch (Exception ex) {
            wscfLogger.i18NLogger.warn_unexpectedException(ex);
            return null;
        }
    }
}

