/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkBulker;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableWork;
import org.hibernate.search.engine.backend.orchestration.spi.BatchedWorkProcessor;

class ElasticsearchBatchedWorkProcessor
implements BatchedWorkProcessor {
    private final ElasticsearchWorkSequenceBuilder sequenceBuilder;
    private final ElasticsearchWorkBulker bulker;

    public ElasticsearchBatchedWorkProcessor(ElasticsearchWorkSequenceBuilder sequenceBuilder, ElasticsearchWorkBulker bulker) {
        this.sequenceBuilder = sequenceBuilder;
        this.bulker = bulker;
    }

    public void beginBatch() {
        this.bulker.reset();
        this.sequenceBuilder.init(CompletableFuture.completedFuture(null));
    }

    public <T> CompletableFuture<T> submit(BulkableWork<T> work) {
        return this.bulker.add(work);
    }

    public CompletableFuture<Void> endBatch() {
        CompletableFuture<Void> future = this.sequenceBuilder.build();
        this.bulker.finalizeBulkWork();
        return future;
    }

    public void complete() {
    }
}

