/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.engine.search.aggregation.AggregationKey;

class ElasticsearchUserProvidedJsonAggregation
extends AbstractElasticsearchAggregation<JsonObject> {
    private final JsonObject requestJson;

    private ElasticsearchUserProvidedJsonAggregation(Builder builder) {
        super(builder);
        this.requestJson = builder.json;
    }

    @Override
    public ElasticsearchSearchAggregation.Extractor<JsonObject> request(AggregationRequestContext context, AggregationKey<?> key, JsonObject jsonAggregations) {
        jsonAggregations.add(key.name(), (JsonElement)this.requestJson);
        return PassThroughExtractor.INSTANCE;
    }

    static class Builder
    extends AbstractElasticsearchAggregation.AbstractBuilder<JsonObject> {
        private final JsonObject json;

        Builder(ElasticsearchSearchIndexScope<?> scope, JsonObject json) {
            super(scope);
            this.json = json;
        }

        @Override
        public ElasticsearchSearchAggregation<JsonObject> build() {
            return new ElasticsearchUserProvidedJsonAggregation(this);
        }
    }

    private static class PassThroughExtractor
    implements ElasticsearchSearchAggregation.Extractor<JsonObject> {
        public static final PassThroughExtractor INSTANCE = new PassThroughExtractor();

        private PassThroughExtractor() {
        }

        @Override
        public JsonObject extract(JsonObject aggregationResult, AggregationExtractContext context) {
            return aggregationResult;
        }
    }
}

