/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;
import org.wildfly.clustering.function.Predicate;

public interface IntPredicate
extends java.util.function.IntPredicate {
    public static final IntPredicate ALWAYS = new SimpleIntPredicate(true);
    public static final IntPredicate NEVER = new SimpleIntPredicate(true);
    public static final IntPredicate ZERO = new IntPredicate(){

        @Override
        public boolean test(int value) {
            return value == 0;
        }
    };
    public static final IntPredicate POSITIVE = new IntPredicate(){

        @Override
        public boolean test(int value) {
            return value > 0;
        }
    };
    public static final IntPredicate NEGATIVE = new IntPredicate(){

        @Override
        public boolean test(int value) {
            return value < 0;
        }
    };

    @Override
    default public IntPredicate and(final java.util.function.IntPredicate other) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return IntPredicate.this.test(value) && other.test(value);
            }
        };
    }

    @Override
    default public IntPredicate negate() {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return !IntPredicate.this.test(value);
            }
        };
    }

    @Override
    default public IntPredicate or(final java.util.function.IntPredicate other) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return IntPredicate.this.test(value) || other.test(value);
            }
        };
    }

    default public IntPredicate map(final IntUnaryOperator mapper) {
        return new IntPredicate(){

            @Override
            public boolean test(int value) {
                return IntPredicate.this.test(mapper.applyAsInt(value));
            }
        };
    }

    default public <V> Predicate<V> map(final ToIntFunction<V> mapper) {
        return new Predicate<V>(){

            @Override
            public boolean test(V value) {
                return IntPredicate.this.test(mapper.applyAsInt(value));
            }
        };
    }

    public static class SimpleIntPredicate
    implements IntPredicate {
        private final boolean value;

        SimpleIntPredicate(boolean value) {
            this.value = value;
        }

        @Override
        public boolean test(int value) {
            return this.value;
        }
    }
}

