/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedExecutorServiceImpl;
import org.jboss.as.threads.ManagedJBossThreadPoolExecutorService;
import org.jboss.as.threads.ManagedQueueExecutorService;
import org.jboss.as.threads.ManagedQueuelessExecutorService;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.EnhancedQueueExecutor;

class ManagedEnhancedQueueExecutor
extends ManagedExecutorServiceImpl
implements ManagedQueueExecutorService,
ManagedQueuelessExecutorService,
ManagedJBossThreadPoolExecutorService {
    private final EnhancedQueueExecutor executor;
    private volatile int maxTasks;
    private volatile ReducableSemaphore semaphore;

    ManagedEnhancedQueueExecutor(EnhancedQueueExecutor executor, boolean blocking) {
        super((ExecutorService)executor);
        this.executor = executor;
        if (blocking) {
            this.maxTasks = ManagedEnhancedQueueExecutor.getMaxTasks(executor);
            this.semaphore = new ReducableSemaphore(this.maxTasks);
        } else {
            this.maxTasks = -1;
            this.semaphore = null;
        }
    }

    @Override
    public boolean isBlocking() {
        return this.maxTasks > 0;
    }

    @Override
    public void execute(Runnable command) {
        ReducableSemaphore gate = this.semaphore;
        if (gate != null) {
            try {
                gate.acquire();
                command = new WrappedRunnable(command, gate);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        this.executor.execute(command);
    }

    @Override
    void internalShutdown(StopContext stopContext) {
        this.executor.shutdown();
        if (this.semaphore != null) {
            ReducableSemaphore gate = this.semaphore;
            this.semaphore = null;
            boolean released = false;
            do {
                try {
                    gate.release(Integer.MAX_VALUE - gate.availablePermits());
                    released = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            } while (!released);
        }
        stopContext.complete();
    }

    @Override
    public int getCoreThreads() {
        return this.executor.getCorePoolSize();
    }

    void setCoreThreads(int coreThreads) {
        this.executor.setCorePoolSize(coreThreads);
    }

    @Override
    public boolean isAllowCoreTimeout() {
        return this.executor.allowsCoreThreadTimeOut();
    }

    void setAllowCoreTimeout(boolean allowCoreTimeout) {
        this.executor.allowCoreThreadTimeOut(allowCoreTimeout);
    }

    @Override
    public int getMaxThreads() {
        return this.executor.getMaximumPoolSize();
    }

    void setMaxThreads(int maxThreads) {
        this.executor.setMaximumPoolSize(maxThreads);
        if (this.semaphore != null) {
            int oldMaxTasks = this.maxTasks;
            this.maxTasks = ManagedEnhancedQueueExecutor.getMaxTasks(this.executor);
            if (this.maxTasks < oldMaxTasks) {
                this.semaphore.reducePermits(oldMaxTasks - this.maxTasks);
            } else if (this.maxTasks != oldMaxTasks) {
                this.semaphore.release(this.maxTasks - oldMaxTasks);
            }
        }
    }

    @Override
    public long getKeepAlive() {
        return this.executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    void setKeepAlive(TimeSpec keepAlive) {
        this.executor.setKeepAliveTime(keepAlive.getDuration(), keepAlive.getUnit());
    }

    @Override
    public int getRejectedCount() {
        return (int)this.executor.getRejectedTaskCount();
    }

    @Override
    public long getTaskCount() {
        return this.executor.getSubmittedTaskCount();
    }

    @Override
    public int getLargestThreadCount() {
        return this.executor.getLargestPoolSize();
    }

    @Override
    public int getLargestPoolSize() {
        return this.executor.getLargestPoolSize();
    }

    @Override
    public int getCurrentThreadCount() {
        return this.executor.getPoolSize();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.executor.getCompletedTaskCount();
    }

    @Override
    public int getActiveCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public int getQueueSize() {
        return this.executor.getQueueSize();
    }

    private static int getMaxTasks(EnhancedQueueExecutor executor) {
        return ManagedEnhancedQueueExecutor.getMaxTasks(executor.getMaximumPoolSize(), executor.getMaximumQueueSize());
    }

    private static int getMaxTasks(int maxThreads, int queueLength) {
        return Integer.MAX_VALUE - queueLength >= maxThreads ? maxThreads + queueLength : Integer.MAX_VALUE;
    }

    private static class ReducableSemaphore
    extends Semaphore {
        ReducableSemaphore(int permits) {
            super(permits);
        }

        @Override
        public void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }

    private static class WrappedRunnable
    implements Runnable {
        private final Runnable wrapped;
        private final Semaphore gate;

        private WrappedRunnable(Runnable wrapped, Semaphore gate) {
            this.wrapped = wrapped;
            this.gate = gate;
        }

        @Override
        public void run() {
            try {
                this.wrapped.run();
            }
            finally {
                this.gate.release();
            }
        }
    }
}

