/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveBoxingDelegate;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import net.bytebuddy.implementation.bytecode.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.jar.asm.Label;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerClassLocator;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImpl;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.bytecode.internal.bytebuddy.ByteBuddyState;
import org.hibernate.bytecode.internal.bytebuddy.InvalidPropertyAccessorException;
import org.hibernate.bytecode.internal.bytebuddy.PrivateAccessorException;
import org.hibernate.bytecode.internal.bytebuddy.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.internal.bytebuddy.ReflectionOptimizerImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.engine.spi.Managed;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.PropertyAccessEmbeddedImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterFieldImpl;
import org.hibernate.property.access.spi.GetterMethodImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterFieldImpl;
import org.hibernate.property.access.spi.SetterMethodImpl;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyProxyHelper;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(BytecodeProviderImpl.class);
    private static final String INSTANTIATOR_PROXY_NAMING_SUFFIX = "HibernateInstantiator";
    private static final String OPTIMIZER_PROXY_NAMING_SUFFIX = "HibernateAccessOptimizer";
    private static final String OPTIMIZER_PROXY_BRIDGE_NAMING_SUFFIX = "HibernateAccessOptimizerBridge";
    private static final ElementMatcher.Junction<NamedElement> newInstanceMethodName = ElementMatchers.named((String)"newInstance");
    private static final ElementMatcher.Junction<NamedElement> getPropertyValuesMethodName = ElementMatchers.named((String)"getPropertyValues");
    private static final ElementMatcher.Junction<NamedElement> setPropertyValuesMethodName = ElementMatchers.named((String)"setPropertyValues");
    private static final ElementMatcher.Junction<NamedElement> getPropertyNamesMethodName = ElementMatchers.named((String)"getPropertyNames");
    private static final Member EMBEDDED_MEMBER = new Member(){

        @Override
        public Class<?> getDeclaringClass() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public int getModifiers() {
            return 0;
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }
    };
    private final ByteBuddyState byteBuddyState;
    private final ByteBuddyProxyHelper byteBuddyProxyHelper;

    public BytecodeProviderImpl() {
        this(ClassFileVersion.ofThisVm((ClassFileVersion)ClassFileVersion.JAVA_V11));
    }

    public BytecodeProviderImpl(ClassFileVersion targetCompatibleJVM) {
        this.byteBuddyState = new ByteBuddyState(targetCompatibleJVM);
        this.byteBuddyProxyHelper = new ByteBuddyProxyHelper(this.byteBuddyState);
    }

    @Override
    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl(this.byteBuddyState, this.byteBuddyProxyHelper);
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        Class<?> fastClass;
        if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            Constructor<?> constructor = BytecodeProviderImpl.findConstructor(clazz);
            if (constructor == null || Modifier.isPrivate(constructor.getModifiers())) {
                fastClass = null;
            } else {
                String className = clazz.getName() + "$HibernateInstantiator";
                fastClass = this.byteBuddyState.load(clazz, className, (byteBuddy, namingStrategy) -> byteBuddy.with(namingStrategy).subclass(ReflectionOptimizer.InstantiationOptimizer.class).method(newInstanceMethodName).intercept((Implementation)MethodCall.construct((Constructor)constructor)));
            }
        } else {
            fastClass = null;
        }
        Method[] getters = new Method[getterNames.length];
        Method[] setters = new Method[setterNames.length];
        try {
            BytecodeProviderImpl.findAccessors(clazz, getterNames, setterNames, types, getters, setters);
        }
        catch (InvalidPropertyAccessorException ex) {
            LOG.unableToGenerateReflectionOptimizer(clazz.getName(), ex.getMessage());
            return null;
        }
        Class<?> bulkAccessor = this.byteBuddyState.load(clazz, byteBuddy -> byteBuddy.with((NamingStrategy)new NamingStrategy.SuffixingRandom(OPTIMIZER_PROXY_NAMING_SUFFIX, (NamingStrategy.SuffixingRandom.BaseNameResolver)new NamingStrategy.SuffixingRandom.BaseNameResolver.ForFixedValue(clazz.getName()))).subclass(Object.class).implement(new java.lang.reflect.Type[]{ReflectionOptimizer.AccessOptimizer.class}).method(getPropertyValuesMethodName).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new GetPropertyValues(clazz, getterNames, getters)})).method(setPropertyValuesMethodName).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new SetPropertyValues(clazz, getterNames, setters)})).method(getPropertyNamesMethodName).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new GetPropertyNames(getterNames)})));
        try {
            return new ReflectionOptimizerImpl(fastClass != null ? (ReflectionOptimizer.InstantiationOptimizer)fastClass.newInstance() : null, (ReflectionOptimizer.AccessOptimizer)bulkAccessor.newInstance());
        }
        catch (Exception exception) {
            throw new HibernateException(exception);
        }
    }

    @Override
    public @Nullable ReflectionOptimizer getReflectionOptimizer(Class<?> clazz, Map<String, PropertyAccess> propertyAccessMap) {
        Class<?> fastClass;
        if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
            Constructor<?> constructor = BytecodeProviderImpl.findConstructor(clazz);
            if (constructor == null || Modifier.isPrivate(constructor.getModifiers())) {
                fastClass = null;
            } else {
                String className = clazz.getName() + "$HibernateInstantiator";
                fastClass = this.byteBuddyState.load(clazz, className, (byteBuddy, namingStrategy) -> byteBuddy.with(namingStrategy).subclass(ReflectionOptimizer.InstantiationOptimizer.class).method(newInstanceMethodName).intercept((Implementation)MethodCall.construct((Constructor)constructor)));
            }
        } else {
            fastClass = null;
        }
        Member[] getters = new Member[propertyAccessMap.size()];
        Member[] setters = new Member[propertyAccessMap.size()];
        try {
            BytecodeProviderImpl.findAccessors(clazz, propertyAccessMap, getters, setters);
        }
        catch (InvalidPropertyAccessorException ex) {
            LOG.unableToGenerateReflectionOptimizer(clazz.getName(), ex.getMessage());
            return null;
        }
        String[] propertyNames = propertyAccessMap.keySet().toArray(new String[0]);
        Class<?> superClass = this.determineAccessOptimizerSuperClass(clazz, propertyNames, getters, setters);
        String className = clazz.getName() + "$HibernateAccessOptimizer" + BytecodeProviderImpl.encodeName(propertyNames, getters, setters);
        Class<?> bulkAccessor = className.getBytes(StandardCharsets.UTF_8).length >= 65536 ? this.byteBuddyState.load(clazz, byteBuddy -> byteBuddy.with((NamingStrategy)new NamingStrategy.SuffixingRandom(OPTIMIZER_PROXY_NAMING_SUFFIX, (NamingStrategy.SuffixingRandom.BaseNameResolver)new NamingStrategy.SuffixingRandom.BaseNameResolver.ForFixedValue(clazz.getName()))).subclass(superClass).implement(new java.lang.reflect.Type[]{ReflectionOptimizer.AccessOptimizer.class}).method(getPropertyValuesMethodName).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new GetPropertyValues(clazz, propertyNames, getters)})).method(setPropertyValuesMethodName).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new SetPropertyValues(clazz, propertyNames, setters)})).method(getPropertyNamesMethodName).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new GetPropertyNames(propertyNames)}))) : this.byteBuddyState.load(clazz, className, (byteBuddy, namingStrategy) -> byteBuddy.with(namingStrategy).subclass(superClass).implement(new java.lang.reflect.Type[]{ReflectionOptimizer.AccessOptimizer.class}).method(getPropertyValuesMethodName).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new GetPropertyValues(clazz, propertyNames, getters)})).method(setPropertyValuesMethodName).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new SetPropertyValues(clazz, propertyNames, setters)})).method(getPropertyNamesMethodName).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new GetPropertyNames(propertyNames)})));
        try {
            return new ReflectionOptimizerImpl(fastClass != null ? (ReflectionOptimizer.InstantiationOptimizer)fastClass.newInstance() : null, (ReflectionOptimizer.AccessOptimizer)bulkAccessor.newInstance());
        }
        catch (Exception exception) {
            throw new HibernateException(exception);
        }
    }

    private Class<?> determineAccessOptimizerSuperClass(Class<?> clazz, String[] propertyNames, Member[] getters, Member[] setters) {
        if (clazz.isInterface()) {
            return Object.class;
        }
        List<BridgeMembersClassInfo> bridgeMembersClassInfos = this.createBridgeMembersClassInfos(clazz, getters, setters, propertyNames);
        Class superClass = Object.class;
        for (int i = bridgeMembersClassInfos.size() - 1; i >= 0; --i) {
            BridgeMembersClassInfo bridgeMembersClassInfo = bridgeMembersClassInfos.get(i);
            Class<Object> newSuperClass = superClass;
            String className = bridgeMembersClassInfo.clazz.getName() + "$HibernateAccessOptimizerBridge" + BytecodeProviderImpl.encodeName(bridgeMembersClassInfo.propertyNames, bridgeMembersClassInfo.getters, bridgeMembersClassInfo.setters);
            superClass = this.byteBuddyState.load(bridgeMembersClassInfo.clazz, className, (byteBuddy, namingStrategy) -> {
                DynamicType.Builder builder = byteBuddy.with(namingStrategy).subclass(newSuperClass);
                for (Member getter : bridgeMembersClassInfo.getters) {
                    if (Modifier.isPublic(getter.getModifiers())) continue;
                    Class<?> getterType = getter instanceof Field ? ((Field)getter).getType() : ((Method)getter).getReturnType();
                    builder = builder.defineMethod("get_" + getter.getName(), (TypeDefinition)TypeDescription.Generic.OfNonGenericType.ForLoadedType.of(getterType), 12).withParameter(bridgeMembersClassInfo.clazz).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new GetFieldOnArgument(getter)}));
                }
                for (Member setter : bridgeMembersClassInfo.setters) {
                    if (Modifier.isPublic(setter.getModifiers())) continue;
                    Class<?> setterType = setter instanceof Field ? ((Field)setter).getType() : ((Method)setter).getParameterTypes()[0];
                    builder = builder.defineMethod("set_" + setter.getName(), (TypeDefinition)TypeDescription.Generic.VOID, 12).withParameter(bridgeMembersClassInfo.clazz).withParameter(setterType).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new SetFieldOnArgument(setter)}));
                }
                return builder;
            });
            for (int j = 0; j < getters.length; ++j) {
                Member getter = getters[j];
                Member setter = setters[j];
                if (bridgeMembersClassInfo.getters.contains(getter) && !Modifier.isPublic(getter.getModifiers())) {
                    getters[j] = new ForeignPackageMember(superClass, getter);
                }
                if (!bridgeMembersClassInfo.setters.contains(setter) || Modifier.isPublic(setter.getModifiers())) continue;
                setters[j] = new ForeignPackageMember(superClass, setter);
            }
        }
        return superClass;
    }

    private static String encodeName(String[] propertyNames, Member[] getters, Member[] setters) {
        return BytecodeProviderImpl.encodeName(Arrays.asList(propertyNames), Arrays.asList(getters), Arrays.asList(setters));
    }

    private static String encodeName(List<String> propertyNames, List<Member> getters, List<Member> setters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < propertyNames.size(); ++i) {
            String propertyName = propertyNames.get(i);
            Member getter = getters.get(i);
            Member setter = setters.get(i);
            sb.append(Integer.toHexString(BytecodeProviderImpl.getKind(getter) << 2 | BytecodeProviderImpl.getKind(setter)));
            sb.append(propertyName);
        }
        return sb.toString();
    }

    private static int getKind(Member member) {
        if (member == EMBEDDED_MEMBER) {
            return 0;
        }
        if (member instanceof Field) {
            return 1;
        }
        if (member instanceof Method) {
            return 2;
        }
        if (member instanceof ForeignPackageMember) {
            return 3;
        }
        throw new IllegalArgumentException("Unknown member type: " + member);
    }

    private List<BridgeMembersClassInfo> createBridgeMembersClassInfos(Class<?> clazz, Member[] getters, Member[] setters, String[] propertyNames) {
        ArrayList<BridgeMembersClassInfo> bridgeMembersClassInfos = new ArrayList<BridgeMembersClassInfo>();
        for (Class<?> c = clazz.getSuperclass(); c != Object.class; c = c.getSuperclass()) {
            BridgeMembersClassInfo bridgeMemberClassInfo = new BridgeMembersClassInfo(c);
            for (int i = 0; i < getters.length; ++i) {
                Member getter = getters[i];
                Member setter = setters[i];
                if ((getter.getDeclaringClass() != c || Modifier.isPublic(getter.getModifiers())) && (setter.getDeclaringClass() != c || Modifier.isPublic(setter.getModifiers()))) continue;
                bridgeMemberClassInfo.getters.add(getter);
                bridgeMemberClassInfo.setters.add(setter);
                bridgeMemberClassInfo.propertyNames.add(propertyNames[i]);
            }
            if (bridgeMemberClassInfo.propertyNames.isEmpty()) continue;
            bridgeMembersClassInfos.add(bridgeMemberClassInfo);
        }
        return bridgeMembersClassInfos;
    }

    public ByteBuddyProxyHelper getByteBuddyProxyHelper() {
        return this.byteBuddyProxyHelper;
    }

    private static void findAccessors(Class<?> clazz, String[] getterNames, String[] setterNames, Class<?>[] types, Method[] getters, Method[] setters) {
        int length = types.length;
        if (setterNames.length != length || getterNames.length != length) {
            throw new HibernateException("bad number of accessors");
        }
        Class[] getParam = new Class[]{};
        Class[] setParam = new Class[1];
        for (int i = 0; i < length; ++i) {
            if (getterNames[i] != null) {
                Method getter = BytecodeProviderImpl.findAccessor(clazz, getterNames[i], getParam);
                if (getter.getReturnType() != types[i]) {
                    throw new HibernateException("wrong return type: " + getterNames[i]);
                }
                getters[i] = getter;
            }
            if (setterNames[i] == null) continue;
            setters[i] = ReflectHelper.setterMethodOrNullBySetterName(clazz, setterNames[i], types[i]);
            if (setters[i] == null) {
                throw new HibernateException(String.format("cannot find an accessor [%s] on type [%s]", setterNames[i], clazz.getName()));
            }
            if (!Modifier.isPrivate(setters[i].getModifiers())) continue;
            throw new PrivateAccessorException("private accessor [" + setterNames[i] + "]");
        }
    }

    private static void findAccessors(Class<?> clazz, Map<String, PropertyAccess> propertyAccessMap, Member[] getters, Member[] setters) {
        int i = 0;
        for (Map.Entry<String, PropertyAccess> entry : propertyAccessMap.entrySet()) {
            AccessibleObject setterMember;
            AccessibleObject getterMember;
            PropertyAccess propertyAccess = entry.getValue();
            if (propertyAccess instanceof PropertyAccessEmbeddedImpl) {
                getters[i] = EMBEDDED_MEMBER;
                setters[i] = EMBEDDED_MEMBER;
                ++i;
                continue;
            }
            Getter getter = propertyAccess.getGetter();
            if (getter == null) {
                throw new InvalidPropertyAccessorException("invalid getter for property [" + entry.getKey() + "]");
            }
            Setter setter = propertyAccess.getSetter();
            if (setter == null) {
                throw new InvalidPropertyAccessorException(String.format("cannot find a setter for [%s] on type [%s]", entry.getKey(), clazz.getName()));
            }
            if (getter instanceof GetterMethodImpl) {
                getterMember = getter.getMethod();
            } else if (getter instanceof GetterFieldImpl) {
                getterMember = ((GetterFieldImpl)getter).getField();
            } else {
                throw new InvalidPropertyAccessorException(String.format("cannot find a getter for [%s] on type [%s]", entry.getKey(), clazz.getName()));
            }
            if (setter instanceof SetterMethodImpl) {
                setterMember = setter.getMethod();
            } else if (setter instanceof SetterFieldImpl) {
                setterMember = ((SetterFieldImpl)setter).getField();
                if (Modifier.isFinal(setterMember.getModifiers())) {
                    throw new InvalidPropertyAccessorException("final accessor [" + setterMember.getName() + "]");
                }
            } else {
                throw new InvalidPropertyAccessorException(String.format("cannot find a setter for [%s] on type [%s]", entry.getKey(), clazz.getName()));
            }
            if (Modifier.isPrivate(getterMember.getModifiers())) {
                throw new PrivateAccessorException("private accessor [" + getterMember.getName() + "]");
            }
            if (Modifier.isPrivate(setterMember.getModifiers())) {
                throw new PrivateAccessorException("private accessor [" + setterMember.getName() + "]");
            }
            getters[i] = getterMember;
            setters[i] = setterMember;
            ++i;
        }
    }

    private static Method findAccessor(Class<?> containerClazz, String name, Class<?>[] params) throws PrivateAccessorException {
        Class<?> clazz = containerClazz;
        try {
            return clazz.getMethod(name, params);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            while (true) {
                try {
                    Method method = clazz.getDeclaredMethod(name, params);
                    if (Modifier.isPrivate(method.getModifiers())) {
                        throw new PrivateAccessorException("private accessor [" + name + "]");
                    }
                    return method;
                }
                catch (NoSuchMethodException e) {
                    if ((clazz = clazz.getSuperclass()) != null) continue;
                    throw new HibernateException(String.format("cannot find an accessor [%s] on type [%s]", name, containerClazz.getName()));
                }
                break;
            }
        }
    }

    private static Constructor<?> findConstructor(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Override
    public @Nullable Enhancer getEnhancer(EnhancementContext enhancementContext) {
        return new EnhancerImpl(enhancementContext, this.byteBuddyState);
    }

    public @Nullable Enhancer getEnhancer(EnhancementContext enhancementContext, EnhancerClassLocator classLocator) {
        return new EnhancerImpl(enhancementContext, this.byteBuddyState, classLocator);
    }

    @Override
    public void resetCaches() {
        this.byteBuddyState.clearState();
    }

    public static class GetPropertyNames
    implements ByteCodeAppender {
        private final String[] propertyNames;

        private GetPropertyNames(String[] propertyNames) {
            this.propertyNames = propertyNames;
        }

        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            methodVisitor.visitLdcInsn((Object)this.propertyNames.length);
            methodVisitor.visitTypeInsn(189, Type.getInternalName(String.class));
            for (int i = 0; i < this.propertyNames.length; ++i) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)i);
                methodVisitor.visitLdcInsn((Object)this.propertyNames[i]);
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitInsn(176);
            return new ByteCodeAppender.Size(4, instrumentedMethod.getStackSize() + 1);
        }
    }

    private static class SetPropertyValues
    implements ByteCodeAppender {
        private final Class<?> clazz;
        private final String[] propertyNames;
        private final Member[] setters;
        private final boolean enhanced;

        public SetPropertyValues(Class<?> clazz, String[] propertyNames, Member[] setters) {
            this.clazz = clazz;
            this.propertyNames = propertyNames;
            this.setters = setters;
            this.enhanced = Managed.class.isAssignableFrom(clazz);
        }

        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            boolean persistentAttributeInterceptable = PersistentAttributeInterceptable.class.isAssignableFrom(this.clazz);
            boolean compositeOwner = CompositeOwner.class.isAssignableFrom(this.clazz);
            Label currentLabel = null;
            Label nextLabel = new Label();
            for (int index = 0; index < this.setters.length; ++index) {
                ForeignPackageMember foreignPackageMember;
                Field field;
                Class<?> type;
                Method setter;
                Member setterMember = this.setters[index];
                if (setterMember == EMBEDDED_MEMBER) continue;
                if (currentLabel != null) {
                    methodVisitor.visitLabel(currentLabel);
                    implementationContext.getFrameGeneration().same(methodVisitor, (List)instrumentedMethod.getParameters().asTypeList());
                }
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(this.clazz));
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitLdcInsn((Object)index);
                methodVisitor.visitInsn(50);
                if (this.enhanced) {
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitFieldInsn(178, Type.getInternalName(LazyPropertyInitializer.class), "UNFETCHED_PROPERTY", Type.getDescriptor(Serializable.class));
                    Label setterLabel = new Label();
                    methodVisitor.visitJumpInsn(166, setterLabel);
                    methodVisitor.visitInsn(87);
                    methodVisitor.visitInsn(87);
                    methodVisitor.visitJumpInsn(167, nextLabel);
                    methodVisitor.visitLabel(setterLabel);
                    implementationContext.getFrameGeneration().full(methodVisitor, Arrays.asList(TypeDescription.ForLoadedType.of(this.clazz), TypeDescription.ForLoadedType.of(Object.class)), Arrays.asList(implementationContext.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class), TypeDescription.ForLoadedType.of(Object[].class)));
                }
                if (setterMember instanceof Method) {
                    setter = (Method)setterMember;
                    type = setter.getParameterTypes()[0];
                } else if (setterMember instanceof Field) {
                    field = (Field)setterMember;
                    type = field.getType();
                } else {
                    foreignPackageMember = (ForeignPackageMember)setterMember;
                    Object underlyingMember = foreignPackageMember.getMember();
                    if (underlyingMember instanceof Method) {
                        Method setter2 = (Method)underlyingMember;
                        type = setter2.getParameterTypes()[0];
                    } else {
                        Field field2 = (Field)underlyingMember;
                        type = field2.getType();
                    }
                }
                if (type.isPrimitive()) {
                    PrimitiveUnboxingDelegate.forReferenceType((TypeDefinition)TypeDescription.Generic.OBJECT).assignUnboxedTo((TypeDescription.Generic)new TypeDescription.Generic.OfNonGenericType.ForLoadedType(type), (Assigner)ReferenceTypeAwareAssigner.INSTANCE, Assigner.Typing.DYNAMIC).apply(methodVisitor, implementationContext);
                } else {
                    methodVisitor.visitTypeInsn(192, Type.getInternalName(type));
                }
                if (setterMember instanceof Method) {
                    setter = (Method)setterMember;
                    methodVisitor.visitMethodInsn(setter.getDeclaringClass().isInterface() ? 185 : 182, Type.getInternalName(setter.getDeclaringClass()), setter.getName(), Type.getMethodDescriptor((Method)setter), setter.getDeclaringClass().isInterface());
                    if (setter.getReturnType() != Void.TYPE) {
                        switch (setter.getReturnType().getTypeName()) {
                            case "long": 
                            case "double": {
                                methodVisitor.visitInsn(88);
                                break;
                            }
                            default: {
                                methodVisitor.visitInsn(87);
                            }
                        }
                    }
                } else if (setterMember instanceof Field) {
                    field = (Field)setterMember;
                    methodVisitor.visitFieldInsn(181, Type.getInternalName(field.getDeclaringClass()), field.getName(), Type.getDescriptor(type));
                } else {
                    foreignPackageMember = (ForeignPackageMember)setterMember;
                    methodVisitor.visitMethodInsn(184, Type.getInternalName(foreignPackageMember.getForeignPackageAccessor()), "set_" + setterMember.getName(), Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(foreignPackageMember.getMember().getDeclaringClass()), Type.getType(type)}), false);
                }
                if (!this.enhanced) continue;
                boolean compositeTracker = CompositeTracker.class.isAssignableFrom(type);
                boolean alreadyHasFrame = false;
                if (compositeOwner && (compositeTracker || !Modifier.isFinal(type.getModifiers()))) {
                    boolean isInterface;
                    String compositeTrackerType;
                    methodVisitor.visitVarInsn(25, 2);
                    methodVisitor.visitLdcInsn((Object)index);
                    methodVisitor.visitInsn(50);
                    methodVisitor.visitInsn(89);
                    Label compositeTrackerFalseLabel = new Label();
                    if (compositeTracker) {
                        compositeTrackerType = Type.getInternalName(type);
                        isInterface = false;
                        methodVisitor.visitJumpInsn(198, compositeTrackerFalseLabel);
                    } else {
                        compositeTrackerType = Type.getInternalName(CompositeTracker.class);
                        methodVisitor.visitTypeInsn(193, compositeTrackerType);
                        isInterface = true;
                        methodVisitor.visitJumpInsn(153, compositeTrackerFalseLabel);
                    }
                    methodVisitor.visitTypeInsn(192, compositeTrackerType);
                    methodVisitor.visitLdcInsn((Object)this.propertyNames[index]);
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitTypeInsn(192, Type.getInternalName(this.clazz));
                    methodVisitor.visitMethodInsn(isInterface ? 185 : 182, compositeTrackerType, "$$_hibernate_setOwner", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(String.class), Type.getType(CompositeOwner.class)}), isInterface);
                    Label compositeTrackerEndLabel = new Label();
                    methodVisitor.visitJumpInsn(167, compositeTrackerEndLabel);
                    methodVisitor.visitLabel(compositeTrackerFalseLabel);
                    implementationContext.getFrameGeneration().full(methodVisitor, Arrays.asList(TypeDescription.ForLoadedType.of(Object.class)), Arrays.asList(implementationContext.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class), TypeDescription.ForLoadedType.of(Object[].class)));
                    methodVisitor.visitInsn(87);
                    methodVisitor.visitLabel(compositeTrackerEndLabel);
                    implementationContext.getFrameGeneration().same(methodVisitor, (List)instrumentedMethod.getParameters().asTypeList());
                    alreadyHasFrame = true;
                }
                if (persistentAttributeInterceptable) {
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitTypeInsn(192, Type.getInternalName(this.clazz));
                    methodVisitor.visitMethodInsn(182, Type.getInternalName(this.clazz), "$$_hibernate_getInterceptor", Type.getMethodDescriptor((Type)Type.getType(PersistentAttributeInterceptor.class), (Type[])new Type[0]), false);
                    methodVisitor.visitInsn(89);
                    methodVisitor.visitTypeInsn(193, Type.getInternalName(BytecodeLazyAttributeInterceptor.class));
                    Label instanceofFalseLabel = new Label();
                    methodVisitor.visitJumpInsn(153, instanceofFalseLabel);
                    methodVisitor.visitTypeInsn(192, Type.getInternalName(BytecodeLazyAttributeInterceptor.class));
                    methodVisitor.visitLdcInsn((Object)this.propertyNames[index]);
                    methodVisitor.visitMethodInsn(185, Type.getInternalName(BytecodeLazyAttributeInterceptor.class), "attributeInitialized", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(String.class)}), true);
                    Label instanceofEndLabel = new Label();
                    methodVisitor.visitJumpInsn(167, instanceofEndLabel);
                    methodVisitor.visitLabel(instanceofFalseLabel);
                    implementationContext.getFrameGeneration().full(methodVisitor, Arrays.asList(TypeDescription.ForLoadedType.of(PersistentAttributeInterceptor.class)), Arrays.asList(implementationContext.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class), TypeDescription.ForLoadedType.of(Object[].class)));
                    methodVisitor.visitInsn(87);
                    methodVisitor.visitLabel(instanceofEndLabel);
                    implementationContext.getFrameGeneration().same(methodVisitor, (List)instrumentedMethod.getParameters().asTypeList());
                    alreadyHasFrame = true;
                }
                if (alreadyHasFrame) {
                    methodVisitor.visitLabel(nextLabel);
                    currentLabel = null;
                } else {
                    currentLabel = nextLabel;
                }
                nextLabel = new Label();
            }
            if (currentLabel != null) {
                methodVisitor.visitLabel(currentLabel);
                implementationContext.getFrameGeneration().same(methodVisitor, (List)instrumentedMethod.getParameters().asTypeList());
            }
            methodVisitor.visitInsn(177);
            return new ByteCodeAppender.Size(4, instrumentedMethod.getStackSize());
        }
    }

    private static class GetPropertyValues
    implements ByteCodeAppender {
        private final Class<?> clazz;
        private final String[] propertyNames;
        private final Member[] getters;
        private final boolean persistentAttributeInterceptable;

        public GetPropertyValues(Class<?> clazz, String[] propertyNames, Member[] getters) {
            this.clazz = clazz;
            this.propertyNames = propertyNames;
            this.getters = getters;
            this.persistentAttributeInterceptable = PersistentAttributeInterceptable.class.isAssignableFrom(clazz);
        }

        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            if (this.persistentAttributeInterceptable) {
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(this.clazz));
                methodVisitor.visitMethodInsn(182, Type.getInternalName(this.clazz), "$$_hibernate_getInterceptor", Type.getMethodDescriptor((Type)Type.getType(PersistentAttributeInterceptor.class), (Type[])new Type[0]), false);
                methodVisitor.visitInsn(89);
                methodVisitor.visitTypeInsn(193, Type.getInternalName(LazyAttributeLoadingInterceptor.class));
                Label instanceofFalseLabel = new Label();
                methodVisitor.visitJumpInsn(153, instanceofFalseLabel);
                methodVisitor.visitTypeInsn(192, Type.getInternalName(LazyAttributeLoadingInterceptor.class));
                methodVisitor.visitVarInsn(58, 2);
                Label instanceofEndLabel = new Label();
                methodVisitor.visitJumpInsn(167, instanceofEndLabel);
                methodVisitor.visitLabel(instanceofFalseLabel);
                implementationContext.getFrameGeneration().full(methodVisitor, Arrays.asList(TypeDescription.ForLoadedType.of(PersistentAttributeInterceptor.class)), Arrays.asList(implementationContext.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class)));
                methodVisitor.visitInsn(87);
                methodVisitor.visitInsn(1);
                methodVisitor.visitVarInsn(58, 2);
                methodVisitor.visitLabel(instanceofEndLabel);
                implementationContext.getFrameGeneration().full(methodVisitor, Collections.emptyList(), Arrays.asList(implementationContext.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class), TypeDescription.ForLoadedType.of(LazyAttributeLoadingInterceptor.class)));
            }
            methodVisitor.visitLdcInsn((Object)this.getters.length);
            methodVisitor.visitTypeInsn(189, Type.getInternalName(Object.class));
            for (int index = 0; index < this.getters.length; ++index) {
                Member getterMember = this.getters[index];
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)index);
                Label arrayStoreLabel = new Label();
                if (getterMember == EMBEDDED_MEMBER) {
                    methodVisitor.visitVarInsn(25, 1);
                } else {
                    Class<?> type;
                    AccessibleObject getter;
                    if (this.persistentAttributeInterceptable) {
                        Label extractValueLabel = new Label();
                        methodVisitor.visitVarInsn(25, 2);
                        methodVisitor.visitJumpInsn(198, extractValueLabel);
                        methodVisitor.visitVarInsn(25, 2);
                        methodVisitor.visitLdcInsn((Object)this.propertyNames[index]);
                        methodVisitor.visitMethodInsn(182, Type.getInternalName(LazyAttributeLoadingInterceptor.class), "isAttributeLoaded", Type.getMethodDescriptor((Type)Type.getType(Boolean.TYPE), (Type[])new Type[]{Type.getType(String.class)}), false);
                        methodVisitor.visitJumpInsn(154, extractValueLabel);
                        methodVisitor.visitFieldInsn(178, Type.getInternalName(LazyPropertyInitializer.class), "UNFETCHED_PROPERTY", Type.getDescriptor(Serializable.class));
                        methodVisitor.visitJumpInsn(167, arrayStoreLabel);
                        methodVisitor.visitLabel(extractValueLabel);
                        implementationContext.getFrameGeneration().full(methodVisitor, Arrays.asList(TypeDescription.ForLoadedType.of(Object[].class), TypeDescription.ForLoadedType.of(Object[].class), TypeDescription.ForLoadedType.of(Integer.TYPE)), Arrays.asList(implementationContext.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class), TypeDescription.ForLoadedType.of(LazyAttributeLoadingInterceptor.class)));
                    }
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitTypeInsn(192, Type.getInternalName(this.clazz));
                    if (getterMember instanceof Method) {
                        getter = (Method)getterMember;
                        type = ((Method)getter).getReturnType();
                        methodVisitor.visitMethodInsn(((Method)getter).getDeclaringClass().isInterface() ? 185 : 182, Type.getInternalName(((Method)getter).getDeclaringClass()), ((Method)getter).getName(), Type.getMethodDescriptor((Method)getter), ((Method)getter).getDeclaringClass().isInterface());
                    } else if (getterMember instanceof Field) {
                        getter = (Field)getterMember;
                        type = ((Field)getter).getType();
                        methodVisitor.visitFieldInsn(180, Type.getInternalName(((Field)getter).getDeclaringClass()), ((Field)getter).getName(), Type.getDescriptor(type));
                    } else {
                        AccessibleObject getter2;
                        assert (getterMember instanceof ForeignPackageMember);
                        ForeignPackageMember foreignPackageMember = (ForeignPackageMember)getterMember;
                        Member underlyingMember = foreignPackageMember.getMember();
                        if (underlyingMember instanceof Method) {
                            getter2 = (Method)underlyingMember;
                            type = ((Method)getter2).getReturnType();
                        } else {
                            getter2 = (Field)underlyingMember;
                            type = ((Field)getter2).getType();
                        }
                        methodVisitor.visitMethodInsn(184, Type.getInternalName(foreignPackageMember.getForeignPackageAccessor()), "get_" + getterMember.getName(), Type.getMethodDescriptor((Type)Type.getType(type), (Type[])new Type[]{Type.getType(underlyingMember.getDeclaringClass())}), false);
                    }
                    if (type.isPrimitive()) {
                        PrimitiveBoxingDelegate.forPrimitive((TypeDefinition)new TypeDescription.ForLoadedType(type)).assignBoxedTo(TypeDescription.Generic.OBJECT, (Assigner)ReferenceTypeAwareAssigner.INSTANCE, Assigner.Typing.STATIC).apply(methodVisitor, implementationContext);
                    }
                }
                if (this.persistentAttributeInterceptable) {
                    methodVisitor.visitLabel(arrayStoreLabel);
                    implementationContext.getFrameGeneration().full(methodVisitor, Arrays.asList(TypeDescription.ForLoadedType.of(Object[].class), TypeDescription.ForLoadedType.of(Object[].class), TypeDescription.ForLoadedType.of(Integer.TYPE), TypeDescription.ForLoadedType.of(Object.class)), Arrays.asList(implementationContext.getInstrumentedType(), TypeDescription.ForLoadedType.of(Object.class), TypeDescription.ForLoadedType.of(LazyAttributeLoadingInterceptor.class)));
                }
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitInsn(176);
            return new ByteCodeAppender.Size(6, instrumentedMethod.getStackSize() + 1);
        }
    }

    private static class SetFieldOnArgument
    implements ByteCodeAppender {
        private final Member setterMember;

        public SetFieldOnArgument(Member setterMember) {
            this.setterMember = setterMember;
        }

        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            Class<?> type;
            methodVisitor.visitVarInsn(25, 0);
            if (this.setterMember instanceof Method) {
                Method setter = (Method)this.setterMember;
                type = setter.getParameterTypes()[0];
                methodVisitor.visitVarInsn(this.getLoadOpCode(type), 1);
                methodVisitor.visitMethodInsn(setter.getDeclaringClass().isInterface() ? 185 : 182, Type.getInternalName(setter.getDeclaringClass()), setter.getName(), Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(type)}), setter.getDeclaringClass().isInterface());
                if (setter.getReturnType() != Void.TYPE) {
                    switch (setter.getReturnType().getTypeName()) {
                        case "long": 
                        case "double": {
                            methodVisitor.visitInsn(88);
                            break;
                        }
                        default: {
                            methodVisitor.visitInsn(87);
                        }
                    }
                }
            } else {
                Field setter = (Field)this.setterMember;
                type = setter.getType();
                methodVisitor.visitVarInsn(this.getLoadOpCode(type), 1);
                methodVisitor.visitFieldInsn(181, Type.getInternalName(setter.getDeclaringClass()), setter.getName(), Type.getDescriptor(type));
            }
            methodVisitor.visitInsn(177);
            return new ByteCodeAppender.Size(this.is64BitType(type) ? 3 : 2, instrumentedMethod.getStackSize());
        }

        private int getLoadOpCode(Class<?> type) {
            if (type.isPrimitive()) {
                switch (type.getTypeName()) {
                    case "long": {
                        return 22;
                    }
                    case "float": {
                        return 23;
                    }
                    case "double": {
                        return 24;
                    }
                }
                return 21;
            }
            return 25;
        }

        private boolean is64BitType(Class<?> type) {
            return type == Long.TYPE || type == Double.TYPE;
        }
    }

    private static class GetFieldOnArgument
    implements ByteCodeAppender {
        private final Member getterMember;

        public GetFieldOnArgument(Member getterMember) {
            this.getterMember = getterMember;
        }

        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            Class<?> type;
            methodVisitor.visitVarInsn(25, 0);
            if (this.getterMember instanceof Method) {
                Method getter = (Method)this.getterMember;
                type = getter.getReturnType();
                methodVisitor.visitMethodInsn(getter.getDeclaringClass().isInterface() ? 185 : 182, Type.getInternalName(getter.getDeclaringClass()), getter.getName(), Type.getMethodDescriptor((Method)getter), getter.getDeclaringClass().isInterface());
            } else {
                Field getter = (Field)this.getterMember;
                type = getter.getType();
                methodVisitor.visitFieldInsn(180, Type.getInternalName(getter.getDeclaringClass()), getter.getName(), Type.getDescriptor(type));
            }
            methodVisitor.visitInsn(this.getReturnOpCode(type));
            return new ByteCodeAppender.Size(2, instrumentedMethod.getStackSize());
        }

        private int getReturnOpCode(Class<?> type) {
            if (type.isPrimitive()) {
                switch (type.getTypeName()) {
                    case "long": {
                        return 173;
                    }
                    case "float": {
                        return 174;
                    }
                    case "double": {
                        return 175;
                    }
                }
                return 172;
            }
            return 176;
        }
    }

    private static class ForeignPackageMember
    implements Member {
        private final Class<?> foreignPackageAccessor;
        private final Member member;

        public ForeignPackageMember(Class<?> foreignPackageAccessor, Member member) {
            this.foreignPackageAccessor = foreignPackageAccessor;
            this.member = member;
        }

        public Class<?> getForeignPackageAccessor() {
            return this.foreignPackageAccessor;
        }

        public Member getMember() {
            return this.member;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.member.getDeclaringClass();
        }

        @Override
        public String getName() {
            return this.member.getName();
        }

        @Override
        public int getModifiers() {
            return this.member.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.member.isSynthetic();
        }
    }

    private static class BridgeMembersClassInfo {
        final Class<?> clazz;
        final List<String> propertyNames = new ArrayList<String>();
        final List<Member> getters = new ArrayList<Member>();
        final List<Member> setters = new ArrayList<Member>();

        public BridgeMembersClassInfo(Class<?> clazz) {
            this.clazz = clazz;
        }
    }
}

