/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeAsyncCompletion;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeFromPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeLinkConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiver;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeReceiverConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPBridgeReceiverManager<E> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AMQPBridgeManager bridgeManager;
    private final AMQPBridgeFromPolicyManager policyManager;
    private final AMQPBridgeReceiverConfiguration configuration;
    private final Set<E> demandTracking = new HashSet();
    private boolean forcedDemand;
    private State state = State.READY;
    private AMQPBridgeReceiver receiver;
    private ScheduledFuture<?> pendingIdleTimeout;
    private AMQPBridgeReceiverRecoveryHandler recoveryHandler;

    public AMQPBridgeReceiverManager(AMQPBridgeFromPolicyManager policyManager, AMQPBridgeReceiverConfiguration configuration) {
        this.policyManager = policyManager;
        this.configuration = configuration;
        this.bridgeManager = policyManager.getBridgeManager();
    }

    protected abstract AMQPBridgeReceiver createBridgeReceiver();

    protected abstract void whenDemandTrackingEntryAdded(E var1);

    protected abstract void whenDemandTrackingEntryRemoved(E var1);

    public void shutdown() {
        this.handleShutdown(true);
    }

    public void shutdownNow() {
        this.handleShutdown(false);
    }

    private void handleShutdown(boolean stopFirst) {
        if (this.state != State.CLOSED) {
            this.state = State.CLOSED;
            try {
                if (this.receiver == null) {
                    return;
                }
                if (stopFirst && this.state != State.STOPPED) {
                    this.tryStopBridgeReceiver();
                } else {
                    this.safeCloseCurrentBridgeReceiver();
                }
            }
            finally {
                this.receiver = null;
                this.demandTracking.forEach(entry -> {
                    try {
                        this.whenDemandTrackingEntryRemoved(entry);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                this.demandTracking.clear();
                if (this.pendingIdleTimeout != null) {
                    this.pendingIdleTimeout.cancel(false);
                    this.pendingIdleTimeout = null;
                }
                this.closeRecoveryHandler();
            }
        }
    }

    public void forceDemand() {
        if (!this.forcedDemand) {
            this.forcedDemand = true;
            if (this.state == State.STOPPED) {
                this.tryRestartBridgeReceiver();
            } else if (this.state == State.READY) {
                this.tryCreateBridgeReceiver();
            }
        }
    }

    public void addDemand(E demand) {
        this.checkClosed();
        if (this.demandTracking.add(demand)) {
            this.whenDemandTrackingEntryAdded(demand);
        }
        if (this.state == State.STOPPED) {
            this.tryRestartBridgeReceiver();
        } else if (this.state == State.READY) {
            this.tryCreateBridgeReceiver();
        }
    }

    public void removeDemand(E demand) {
        this.checkClosed();
        if (this.demandTracking.remove(demand)) {
            this.whenDemandTrackingEntryRemoved(demand);
        }
        if (this.hasDemand() || this.state == State.READY) {
            return;
        }
        if (this.state != State.STOPPING) {
            this.tryStopBridgeReceiver();
        }
    }

    private void tryCreateBridgeReceiver() {
        this.state = State.STARTING;
        this.receiver = this.createBridgeReceiver();
        logger.trace("Bridge receiver manager creating remote receiver for: {}", (Object)this.receiver.getReceiverInfo());
        this.receiver.setRemoteOpenHandler(openedReceiver -> {
            AMQPBridgeFromPolicyManager aMQPBridgeFromPolicyManager = this.policyManager;
            synchronized (aMQPBridgeFromPolicyManager) {
                if (this.state == State.STARTING) {
                    this.state = State.STARTED;
                }
                this.closeRecoveryHandler();
            }
        });
        this.receiver.setRemoteClosedHandler(closedReceiver -> {
            AMQPBridgeFromPolicyManager aMQPBridgeFromPolicyManager = this.policyManager;
            synchronized (aMQPBridgeFromPolicyManager) {
                this.safeCloseCurrentBridgeReceiver();
                if (this.hasDemand() && this.configuration.isLinkRecoveryEnabled() && this.state == State.READY) {
                    boolean scheduled;
                    if (this.recoveryHandler == null) {
                        this.recoveryHandler = new AMQPBridgeReceiverRecoveryHandler(this, this.configuration);
                    }
                    if (!(scheduled = this.recoveryHandler.tryScheduleNextRecovery(this.bridgeManager.getScheduler()))) {
                        this.closeRecoveryHandler();
                    }
                }
            }
        });
        this.receiver.initialize();
    }

    private void tryRestartBridgeReceiver() {
        block3: {
            this.state = State.STARTING;
            try {
                if (this.pendingIdleTimeout != null) {
                    this.pendingIdleTimeout.cancel(false);
                    this.pendingIdleTimeout = null;
                }
                this.receiver.startAsync(new AMQPBridgeAsyncCompletion<AMQPBridgeReceiver>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onComplete(AMQPBridgeReceiver receiver) {
                        logger.trace("Restarted Bridge receiver after new demand added.");
                        AMQPBridgeFromPolicyManager aMQPBridgeFromPolicyManager = AMQPBridgeReceiverManager.this.policyManager;
                        synchronized (aMQPBridgeFromPolicyManager) {
                            if (AMQPBridgeReceiverManager.this.state == State.STARTING) {
                                AMQPBridgeReceiverManager.this.state = State.STARTED;
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onException(AMQPBridgeReceiver receiver, Exception error) {
                        if (error instanceof IllegalStateException) {
                            return;
                        }
                        logger.trace("Start of bridge receiver {} threw unexpected error, closing receiver: ", (Object)receiver, (Object)error);
                        AMQPBridgeFromPolicyManager aMQPBridgeFromPolicyManager = AMQPBridgeReceiverManager.this.policyManager;
                        synchronized (aMQPBridgeFromPolicyManager) {
                            AMQPBridgeReceiverManager.this.safeCloseCurrentBridgeReceiver();
                        }
                    }
                });
            }
            catch (Exception ex) {
                logger.trace("Caught error on attempted restart of existing bridge receiver", (Throwable)ex);
                this.safeCloseCurrentBridgeReceiver();
                if (this.state != State.READY) break block3;
                this.tryCreateBridgeReceiver();
            }
        }
    }

    private void tryStopBridgeReceiver() {
        if (this.receiver != null && this.state != State.STOPPING) {
            this.state = this.state == State.CLOSED ? State.CLOSED : State.STOPPING;
            this.receiver.stopAsync(new AMQPBridgeAsyncCompletion<AMQPBridgeReceiver>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(AMQPBridgeReceiver receiver) {
                    logger.trace("Stop of bridge receiver {} succeeded, receiver: ", (Object)receiver);
                    AMQPBridgeFromPolicyManager aMQPBridgeFromPolicyManager = AMQPBridgeReceiverManager.this.policyManager;
                    synchronized (aMQPBridgeFromPolicyManager) {
                        AMQPBridgeReceiverManager.this.handleBridgeReceiverStopped(receiver, true);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onException(AMQPBridgeReceiver receiver, Exception error) {
                    logger.trace("Stop of bridge receiver {} failed, closing receiver: ", (Object)receiver, (Object)error);
                    AMQPBridgeFromPolicyManager aMQPBridgeFromPolicyManager = AMQPBridgeReceiverManager.this.policyManager;
                    synchronized (aMQPBridgeFromPolicyManager) {
                        AMQPBridgeReceiverManager.this.handleBridgeReceiverStopped(receiver, false);
                    }
                }
            });
        }
    }

    private void handleBridgeReceiverStopped(AMQPBridgeReceiver stoppedReceiver, boolean didStop) {
        if (this.state == State.STOPPING) {
            if (!didStop) {
                this.safeCloseCurrentBridgeReceiver();
            } else {
                this.state = State.STOPPED;
            }
            if (this.state == State.READY) {
                if (this.hasDemand()) {
                    this.tryCreateBridgeReceiver();
                }
            } else if (this.state == State.STOPPED) {
                if (this.hasDemand()) {
                    this.tryRestartBridgeReceiver();
                } else if (this.receiver.getReceiverIdleTimeout() > 0) {
                    this.pendingIdleTimeout = this.bridgeManager.getScheduler().schedule(() -> {
                        AMQPBridgeFromPolicyManager aMQPBridgeFromPolicyManager = this.policyManager;
                        synchronized (aMQPBridgeFromPolicyManager) {
                            logger.debug("Bridge receiver {} idle timeout reached, closing now", (Object)this.receiver.getReceiverInfo());
                            if (this.state == State.STOPPED) {
                                this.safeCloseCurrentBridgeReceiver();
                                this.pendingIdleTimeout = null;
                            }
                        }
                    }, (long)this.receiver.getReceiverIdleTimeout(), TimeUnit.MILLISECONDS);
                } else {
                    this.safeCloseCurrentBridgeReceiver();
                }
            }
        } else if (this.state == State.CLOSED) {
            this.safeCloseCurrentBridgeReceiver(stoppedReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryRecoverReceiver() {
        AMQPBridgeFromPolicyManager aMQPBridgeFromPolicyManager = this.policyManager;
        synchronized (aMQPBridgeFromPolicyManager) {
            if (this.state == State.READY && this.hasDemand()) {
                this.tryCreateBridgeReceiver();
            } else {
                this.closeRecoveryHandler();
            }
        }
    }

    private void safeCloseCurrentBridgeReceiver() {
        try {
            this.safeCloseCurrentBridgeReceiver(this.receiver);
            this.state = this.state == State.CLOSED ? State.CLOSED : State.READY;
        }
        catch (Throwable throwable) {
            this.state = this.state == State.CLOSED ? State.CLOSED : State.READY;
            this.receiver = null;
            if (this.pendingIdleTimeout != null) {
                this.pendingIdleTimeout.cancel(false);
                this.pendingIdleTimeout = null;
            }
            throw throwable;
        }
        this.receiver = null;
        if (this.pendingIdleTimeout != null) {
            this.pendingIdleTimeout.cancel(false);
            this.pendingIdleTimeout = null;
        }
    }

    private void safeCloseCurrentBridgeReceiver(AMQPBridgeReceiver receiver) {
        if (receiver != null) {
            try {
                if (!receiver.isClosed()) {
                    receiver.close();
                }
            }
            catch (Exception e) {
                logger.trace("Suppressed error on close of bridge receiver. ", (Throwable)e);
            }
        }
    }

    private boolean hasDemand() {
        return !this.demandTracking.isEmpty() || this.forcedDemand;
    }

    private void checkClosed() {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("The bridge receiver has been closed already");
        }
    }

    private void closeRecoveryHandler() {
        if (this.recoveryHandler != null) {
            try {
                this.recoveryHandler.close();
            }
            finally {
                this.recoveryHandler = null;
            }
        }
    }

    private static enum State {
        READY,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        CLOSED;

    }

    public static class AMQPBridgeReceiverRecoveryHandler
    implements Closeable {
        private final AMQPBridgeReceiverManager<?> manager;
        private final AMQPBridgeLinkConfiguration configuration;
        private final int maxRecoveryAttempts;
        private final AtomicInteger recoveryAttempts = new AtomicInteger();
        private final AtomicLong nextRecoveryDelay = new AtomicLong();
        private volatile ScheduledFuture<?> recoveryFuture;

        public AMQPBridgeReceiverRecoveryHandler(AMQPBridgeReceiverManager<?> manager, AMQPBridgeLinkConfiguration configuration) {
            this.manager = manager;
            this.configuration = configuration;
            this.nextRecoveryDelay.set(configuration.getLinkRecoveryInitialDelay() > 0L ? configuration.getLinkRecoveryInitialDelay() : 1L);
            this.maxRecoveryAttempts = configuration.getMaxLinkRecoveryAttempts();
        }

        @Override
        public void close() {
            ScheduledFuture<?> future = this.recoveryFuture;
            if (future != null) {
                future.cancel(false);
            }
            this.recoveryFuture = null;
        }

        public boolean tryScheduleNextRecovery(ScheduledExecutorService scheduler) {
            Objects.requireNonNull(scheduler, "The scheduler to use cannot be null");
            if (this.maxRecoveryAttempts < 0 || this.recoveryAttempts.get() < this.maxRecoveryAttempts) {
                this.recoveryFuture = scheduler.schedule(this::handleReconnectionAttempt, this.nextRecoveryDelay.get(), TimeUnit.MILLISECONDS);
                return true;
            }
            return false;
        }

        private void handleReconnectionAttempt() {
            ScheduledFuture<?> future = this.recoveryFuture;
            try {
                if (future != null && !future.isCancelled()) {
                    if (this.maxRecoveryAttempts > 0) {
                        this.recoveryAttempts.incrementAndGet();
                    }
                    this.nextRecoveryDelay.set(this.configuration.getLinkRecoveryDelay() > 0L ? this.configuration.getLinkRecoveryDelay() : 1L);
                    this.manager.tryRecoverReceiver();
                }
            }
            finally {
                this.recoveryFuture = null;
            }
        }
    }
}

