/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.exporters;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.smallrye.opentelemetry.implementation.exporters.OtlpExporterUtil;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.ProxyOptions;
import java.net.URI;
import java.util.function.Consumer;

class HttpClientOptionsConsumer
implements Consumer<HttpClientOptions> {
    private final ConfigProperties config;
    private final URI baseUri;
    private final String signalType;

    public HttpClientOptionsConsumer(ConfigProperties config, URI baseUri, String signalType) {
        this.config = config;
        this.baseUri = baseUri;
        this.signalType = signalType;
    }

    @Override
    public void accept(HttpClientOptions options) {
        this.configureTLS(options);
        if (Boolean.parseBoolean(OtlpExporterUtil.getConfig(this.config, "false", "otel.exporter.proxy.enabled"))) {
            this.configureProxyOptions(options);
        }
    }

    private void configureTLS(HttpClientOptions options) {
        this.configureKeyCertOptions(options);
        this.configureTrustOptions(options);
        if (OtlpExporterUtil.isHttps(this.baseUri)) {
            options.setSsl(true);
            options.setUseAlpn(true);
        }
        if (Boolean.parseBoolean(OtlpExporterUtil.getConfig(this.config, "false", "otel.exporter.tls.trustAll"))) {
            options.setTrustAll(true);
            options.setVerifyHost(false);
        }
    }

    private void configureProxyOptions(HttpClientOptions options) {
        String proxyHost = OtlpExporterUtil.getConfig(this.config, "", "otel.exporter.proxy.host");
        if (!proxyHost.isBlank()) {
            ProxyOptions proxyOptions = new ProxyOptions().setHost(proxyHost);
            String proxyPort = OtlpExporterUtil.getConfig(this.config, "", "otel.exporter.proxy.port");
            String proxyUsername = OtlpExporterUtil.getConfig(this.config, "", "otel.exporter.proxy.username");
            String proxyPassword = OtlpExporterUtil.getConfig(this.config, "", "otel.exporter.proxy.password");
            if (!proxyPort.isBlank()) {
                proxyOptions.setPort(Integer.parseInt(proxyPort));
            }
            if (!proxyUsername.isBlank()) {
                proxyOptions.setUsername(proxyUsername);
            }
            if (!proxyPassword.isBlank()) {
                proxyOptions.setPassword(proxyPassword);
            }
            options.setProxyOptions(proxyOptions);
        } else {
            this.configureProxyOptionsFromJDKSysProps(options);
        }
    }

    private void configureProxyOptionsFromJDKSysProps(HttpClientOptions options) {
        String proxyHost = options.isSsl() ? System.getProperty("https.proxyHost", "none") : System.getProperty("http.proxyHost", "none");
        String proxyPortAsString = options.isSsl() ? System.getProperty("https.proxyPort", "443") : System.getProperty("http.proxyPort", "80");
        int proxyPort = Integer.parseInt(proxyPortAsString);
        if (!"none".equals(proxyHost)) {
            String proxyPassword;
            String proxyUser;
            ProxyOptions proxyOptions = new ProxyOptions().setHost(proxyHost).setPort(proxyPort);
            String string = proxyUser = options.isSsl() ? System.getProperty("https.proxyUser") : System.getProperty("http.proxyUser");
            if (proxyUser != null && !proxyUser.isBlank()) {
                proxyOptions.setUsername(proxyUser);
            }
            String string2 = proxyPassword = options.isSsl() ? System.getProperty("https.proxyPassword") : System.getProperty("http.proxyPassword");
            if (proxyPassword != null && !proxyPassword.isBlank()) {
                proxyOptions.setPassword(proxyPassword);
            }
            options.setProxyOptions(proxyOptions);
        }
    }

    private void configureKeyCertOptions(HttpClientOptions options) {
        PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions();
        String certificate = OtlpExporterUtil.getConfig(this.config, "", String.format("otel.exporter.otlp.%s.client.certificate", this.signalType), "otel.exporter.otlp.client.certificate");
        String key = OtlpExporterUtil.getConfig(this.config, "", String.format("otel.exporter.otlp.%s.client.key", this.signalType), "otel.exporter.otlp.client.key");
        if (!certificate.isEmpty()) {
            pemKeyCertOptions.addCertPath(certificate);
        }
        if (!key.isEmpty()) {
            pemKeyCertOptions.addKeyPath(key);
        }
        options.setKeyCertOptions((KeyCertOptions)pemKeyCertOptions);
    }

    private void configureTrustOptions(HttpClientOptions options) {
        String certificate = OtlpExporterUtil.getConfig(this.config, "", String.format("otel.exporter.otlp.%s.certificate", this.signalType), "otel.exporter.otlp.certificate");
        if (!certificate.isEmpty()) {
            PemTrustOptions pemTrustOptions = new PemTrustOptions().addCertPath(certificate);
            options.setPemTrustOptions(pemTrustOptions);
        }
    }
}

