/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.amqp;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.amqp.AmqpSenderOptions;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.amqp.AmqpReceiver;
import io.vertx.mutiny.amqp.AmqpSender;
import io.vertx.proton.ProtonConnection;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.amqp.AmqpConnection.class)
public class AmqpConnection {
    public static final TypeArg<AmqpConnection> __TYPE_ARG = new TypeArg(obj -> new AmqpConnection((io.vertx.amqp.AmqpConnection)obj), AmqpConnection::getDelegate);
    private final io.vertx.amqp.AmqpConnection delegate;

    public AmqpConnection(io.vertx.amqp.AmqpConnection delegate) {
        this.delegate = delegate;
    }

    public AmqpConnection(Object delegate) {
        this.delegate = (io.vertx.amqp.AmqpConnection)delegate;
    }

    AmqpConnection() {
        this.delegate = null;
    }

    public io.vertx.amqp.AmqpConnection getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmqpConnection that = (AmqpConnection)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Fluent
    private AmqpConnection __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public AmqpConnection exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(done -> this.delegate.close(done));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    @Fluent
    public AmqpConnection closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AmqpReceiver> createReceiver(String address) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createReceiver(address, (Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpReceiver.newInstance(event)))));
    }

    public AmqpReceiver createReceiverAndAwait(String address) {
        return (AmqpReceiver)this.createReceiver(address).await().indefinitely();
    }

    @Fluent
    public AmqpConnection createReceiverAndForget(String address) {
        this.createReceiver(address).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AmqpReceiver> createReceiver(String address, AmqpReceiverOptions receiverOptions) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createReceiver(address, receiverOptions, (Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpReceiver.newInstance(event)))));
    }

    public AmqpReceiver createReceiverAndAwait(String address, AmqpReceiverOptions receiverOptions) {
        return (AmqpReceiver)this.createReceiver(address, receiverOptions).await().indefinitely();
    }

    @Fluent
    public AmqpConnection createReceiverAndForget(String address, AmqpReceiverOptions receiverOptions) {
        this.createReceiver(address, receiverOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AmqpReceiver> createDynamicReceiver() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createDynamicReceiver((Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpReceiver.newInstance(event)))));
    }

    public AmqpReceiver createDynamicReceiverAndAwait() {
        return (AmqpReceiver)this.createDynamicReceiver().await().indefinitely();
    }

    @Fluent
    public AmqpConnection createDynamicReceiverAndForget() {
        this.createDynamicReceiver().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AmqpSender> createSender(String address) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createSender(address, (Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpSender.newInstance(event)))));
    }

    public AmqpSender createSenderAndAwait(String address) {
        return (AmqpSender)this.createSender(address).await().indefinitely();
    }

    @Fluent
    public AmqpConnection createSenderAndForget(String address) {
        this.createSender(address).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AmqpSender> createSender(String address, AmqpSenderOptions options) {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createSender(address, options, (Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpSender.newInstance(event)))));
    }

    public AmqpSender createSenderAndAwait(String address, AmqpSenderOptions options) {
        return (AmqpSender)this.createSender(address, options).await().indefinitely();
    }

    @Fluent
    public AmqpConnection createSenderAndForget(String address, AmqpSenderOptions options) {
        this.createSender(address, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<AmqpSender> createAnonymousSender() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.createAnonymousSender((Handler)new DelegatingHandler(completionHandler, ar -> ar.map(event -> AmqpSender.newInstance(event)))));
    }

    public AmqpSender createAnonymousSenderAndAwait() {
        return (AmqpSender)this.createAnonymousSender().await().indefinitely();
    }

    @Fluent
    public AmqpConnection createAnonymousSenderAndForget() {
        this.createAnonymousSender().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public boolean isDisconnected() {
        boolean ret = this.delegate.isDisconnected();
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> closeFuture() {
        return UniHelper.toUni((Future)this.delegate.closeFuture());
    }

    public Void closeFutureAndAwait() {
        return (Void)this.closeFuture().await().indefinitely();
    }

    public void closeFutureAndForget() {
        this.closeFuture().subscribe().with(UniHelper.NOOP);
    }

    public ProtonConnection unwrap() {
        ProtonConnection ret = this.delegate.unwrap();
        return ret;
    }

    public static AmqpConnection newInstance(io.vertx.amqp.AmqpConnection arg) {
        return arg != null ? new AmqpConnection(arg) : null;
    }
}

