/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.bootstrap;

import com.arjuna.ats.jbossatx.jta.TransactionManagerService;
import jakarta.resource.spi.XATerminator;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.txn.integration.JBossContextXATerminator;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.bootstrapcontext.BootstrapContextCoordinator;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public final class BootStrapContextService
implements Service<CloneableBootstrapContext> {
    private final CloneableBootstrapContext value;
    private final String name;
    private final boolean usingDefaultWm;
    private final InjectedValue<WorkManager> workManagerValue = new InjectedValue();
    private final InjectedValue<TransactionManagerService> txManager = new InjectedValue();
    private final InjectedValue<JBossContextXATerminator> xaTerminator = new InjectedValue();
    private final InjectedValue<JcaSubsystemConfiguration> jcaConfig = new InjectedValue();

    public Value<WorkManager> getWorkManagerValue() {
        return this.workManagerValue;
    }

    public BootStrapContextService(CloneableBootstrapContext value, String name, boolean usingDefaultWm) {
        ConnectorLogger.ROOT_LOGGER.debugf("Building DefaultBootstrapContext", new Object[0]);
        this.value = value;
        this.name = name;
        this.usingDefaultWm = usingDefaultWm;
    }

    public CloneableBootstrapContext getValue() throws IllegalStateException {
        return ConnectorServices.notNull(this.value);
    }

    public void start(StartContext context) throws StartException {
        this.value.setWorkManager((WorkManager)this.workManagerValue.getValue());
        this.value.setTransactionSynchronizationRegistry(((TransactionManagerService)this.txManager.getValue()).getTransactionSynchronizationRegistry());
        this.value.setXATerminator((XATerminator)this.xaTerminator.getValue());
        ((JcaSubsystemConfiguration)this.jcaConfig.getValue()).getBootstrapContexts().put(this.name, this.value);
        if (this.usingDefaultWm) {
            ((JcaSubsystemConfiguration)this.jcaConfig.getValue()).setDefaultBootstrapContext(this.value);
            BootstrapContextCoordinator.getInstance().setDefaultBootstrapContext(this.value);
        } else {
            BootstrapContextCoordinator.getInstance().registerBootstrapContext(this.value);
        }
        ConnectorLogger.ROOT_LOGGER.debugf("Starting JCA DefaultBootstrapContext", new Object[0]);
    }

    public void stop(StopContext context) {
        ((JcaSubsystemConfiguration)this.jcaConfig.getValue()).getBootstrapContexts().remove(this.name);
        if (this.usingDefaultWm) {
            ((JcaSubsystemConfiguration)this.jcaConfig.getValue()).setDefaultBootstrapContext(null);
            BootstrapContextCoordinator.getInstance().setDefaultBootstrapContext(null);
        } else {
            BootstrapContextCoordinator.getInstance().unregisterBootstrapContext(this.value);
        }
    }

    public Injector<TransactionManagerService> getTxManagerInjector() {
        return this.txManager;
    }

    public Injector<JBossContextXATerminator> getXaTerminatorInjector() {
        return this.xaTerminator;
    }

    public Injector<WorkManager> getWorkManagerValueInjector() {
        return this.workManagerValue;
    }

    public Injector<JcaSubsystemConfiguration> getJcaConfigInjector() {
        return this.jcaConfig;
    }
}

