/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public interface MapEntry<K, V>
extends Map.Entry<K, V>,
Serializable {
    default public <KK, VV> MapEntry<KK, VV> map(Function<K, KK> keyMapper, Function<V, VV> valueMapper) {
        return MapEntry.of(keyMapper.apply(this.getKey()), valueMapper.apply(this.getValue()));
    }

    @Override
    default public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    public static <K, V> MapEntry<K, V> of(K key, V value) {
        return new SimpleMapEntry<K, V>(key, value);
    }

    public static class SimpleMapEntry<K, V>
    implements MapEntry<K, V> {
        private static final long serialVersionUID = -2330498313768028514L;
        private final K key;
        private final V value;

        SimpleMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.key, entry.getKey()) && Objects.equals(this.value, entry.getValue());
        }

        public String toString() {
            return String.format("%s=%s", this.key, this.value);
        }
    }
}

