/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.wildfly.clustering.function.UnaryOperator;

public interface Supplied<T> {
    public static final Supplied<?> SIMPLE = new Supplied<Object>(){

        @Override
        public Object get(Supplier<Object> supplier) {
            return supplier.get();
        }
    };

    public T get(Supplier<T> var1);

    public static <T> Supplied<T> cached() {
        final AtomicReference reference = new AtomicReference();
        return new Supplied<T>(){

            @Override
            public T get(Supplier<T> factory) {
                return reference.updateAndGet(UnaryOperator.identity().orDefault(Objects::nonNull, factory));
            }
        };
    }

    public static <T> Supplied<T> simple() {
        return SIMPLE;
    }
}

