/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.AbstractConvertingDelegatingDefaultBridge;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.DefaultZonedDateTimeBridge;

public final class DefaultJavaUtilCalendarBridge
extends AbstractConvertingDelegatingDefaultBridge<Calendar, ZonedDateTime> {
    public static final DefaultJavaUtilCalendarBridge INSTANCE = new DefaultJavaUtilCalendarBridge();

    public DefaultJavaUtilCalendarBridge() {
        super(DefaultZonedDateTimeBridge.INSTANCE);
    }

    @Override
    protected ZonedDateTime toConvertedValue(Calendar value) {
        if (value instanceof GregorianCalendar) {
            return ((GregorianCalendar)value).toZonedDateTime();
        }
        return value.toInstant().atZone(ZoneId.of("UTC"));
    }

    @Override
    protected Calendar fromConvertedValue(ZonedDateTime value) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(value.getZone()), Locale.getDefault());
        if (calendar instanceof GregorianCalendar) {
            calendar.setTimeInMillis(Math.addExact(Math.multiplyExact(value.toEpochSecond(), 1000L), (long)value.get(ChronoField.MILLI_OF_SECOND)));
        } else {
            calendar.setTime(Date.from(value.toInstant()));
        }
        return calendar;
    }
}

