/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.manager;

import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.util.logging.Log;
import org.jboss.as.clustering.infinispan.dataconversion.MediaTypeFactory;
import org.jboss.as.clustering.infinispan.manager.DefaultCacheContainerAdmin;
import org.jboss.as.clustering.infinispan.marshalling.MarshallerFactory;
import org.jboss.as.clustering.infinispan.marshalling.UserMarshallerFactory;
import org.jboss.modules.ModuleLoader;
import org.wildfly.clustering.cache.infinispan.embedded.marshall.EncoderRegistry;
import org.wildfly.clustering.cache.infinispan.marshalling.MarshalledValueTranscoder;
import org.wildfly.clustering.cache.infinispan.marshalling.MediaTypes;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledKeyFactory;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DefaultCacheContainer
extends AbstractDelegatingEmbeddedCacheManager {
    private final EmbeddedCacheManagerAdmin administrator = new DefaultCacheContainerAdmin((EmbeddedCacheManager)this);
    private final ModuleLoader loader;
    private final MarshallerFactory marshallerFactory;

    public DefaultCacheContainer(EmbeddedCacheManager container, ModuleLoader loader) {
        super(container);
        this.loader = loader;
        this.marshallerFactory = UserMarshallerFactory.forMediaType(container.getCacheManagerConfiguration().serialization().marshaller().mediaType());
    }

    public Address getAddress() {
        Address address = super.getAddress();
        return address != null ? address : LocalModeAddress.INSTANCE;
    }

    public Address getCoordinator() {
        Address coordinator = super.getCoordinator();
        return coordinator != null ? coordinator : LocalModeAddress.INSTANCE;
    }

    public List<Address> getMembers() {
        List<Address> members = super.getMembers();
        return members != null ? members : Collections.singletonList(LocalModeAddress.INSTANCE);
    }

    public void start() {
    }

    public void stop() {
    }

    public <K, V> Cache<K, V> getCache() {
        return this.getCache((String)this.cm.getCacheManagerConfiguration().defaultCacheName().orElseThrow(() -> ((Log)Log.CONFIG).noDefaultCache()));
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(final String cacheName, final boolean createIfAbsent) {
        EncoderRegistry registry;
        Cache cache = (Cache)AccessController.doPrivileged(new PrivilegedAction<Cache<K, V>>(){

            @Override
            public Cache<K, V> run() {
                return DefaultCacheContainer.this.cm.getCache(cacheName, createIfAbsent);
            }
        });
        if (cache == null) {
            return null;
        }
        Configuration configuration = cache.getCacheConfiguration();
        CacheMode mode = configuration.clustering().cacheMode();
        boolean hasStore = configuration.persistence().usingStores();
        if (!mode.isClustered() && !hasStore && configuration.memory().storage().canStoreReferences() || !this.cm.getCacheManagerConfiguration().serialization().marshaller().mediaType().equals((Object)MediaTypes.WILDFLY_PROTOSTREAM.get())) {
            return new DefaultCache((EmbeddedCacheManager)this, cache);
        }
        final ClassLoader loader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        Map.Entry<MediaType, MediaType> types = MediaTypeFactory.INSTANCE.apply(loader);
        final MediaType keyType = types.getKey();
        final MediaType valueType = !mode.isInvalidation() || hasStore ? types.getValue() : MediaType.APPLICATION_OBJECT;
        EncoderRegistry encoderRegistry = registry = (EncoderRegistry)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)this.cm, org.infinispan.marshall.core.EncoderRegistry.class);
        synchronized (encoderRegistry) {
            boolean registerValueMediaType;
            final boolean registerKeyMediaType = !registry.isConversionSupported(keyType, MediaType.APPLICATION_OBJECT);
            boolean bl = registerValueMediaType = !registry.isConversionSupported(valueType, MediaType.APPLICATION_OBJECT);
            if (registerKeyMediaType || registerValueMediaType) {
                final ClassLoader managerLoader = this.cm.getCacheManagerConfiguration().classLoader();
                PrivilegedAction<ClassLoader> action = new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return new AggregatedClassLoader(List.of(loader, managerLoader));
                    }
                };
                ByteBufferMarshaller marshaller = this.marshallerFactory.createByteBufferMarshaller(this.loader, List.of((ClassLoader)WildFlySecurityManager.doUnchecked((PrivilegedAction)action)));
                if (registerKeyMediaType) {
                    ByteBufferMarshalledKeyFactory keyFactory = new ByteBufferMarshalledKeyFactory(marshaller);
                    registry.registerTranscoder((Transcoder)new MarshalledValueTranscoder(keyType, (MarshalledValueFactory)keyFactory));
                }
                if (registerValueMediaType) {
                    ByteBufferMarshalledValueFactory valueFactory = new ByteBufferMarshalledValueFactory(marshaller);
                    registry.registerTranscoder((Transcoder)new MarshalledValueTranscoder(valueType, (MarshalledValueFactory)valueFactory));
                }
            }
            AdvancedCache advancedCache = cache.getAdvancedCache();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl29 : MonitorExitStatement: MONITOREXIT : var12_12
            EncodingConfiguration encoding = configuration.encoding();
            return new DefaultCache<K, V>((EmbeddedCacheManager)this, encoding.keyDataType().mediaType().equals((Object)keyType) && encoding.valueDataType().mediaType().equals((Object)valueType) ? advancedCache : advancedCache.withMediaType(keyType, valueType)){

                public void stop() {
                    super.stop();
                    if (registerKeyMediaType) {
                        registry.unregisterTranscoder(keyType);
                    }
                    if (registerValueMediaType) {
                        registry.unregisterTranscoder(valueType);
                    }
                }
            };
        }
    }

    public Configuration defineConfiguration(final String cacheName, final Configuration configuration) {
        final EmbeddedCacheManager manager = this.cm;
        PrivilegedAction<Configuration> action = new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return manager.defineConfiguration(cacheName, configuration);
            }
        };
        return (Configuration)WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
    }

    public Configuration defineConfiguration(final String cacheName, final String templateCacheName, final Configuration configurationOverride) {
        final EmbeddedCacheManager manager = this.cm;
        PrivilegedAction<Configuration> action = new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return manager.defineConfiguration(cacheName, templateCacheName, configurationOverride);
            }
        };
        return (Configuration)WildFlySecurityManager.doUnchecked((PrivilegedAction)action);
    }

    public void addListener(final Object listener) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                DefaultCacheContainer.super.addListener(listener);
                return null;
            }
        });
    }

    public CompletionStage<Void> addListenerAsync(final Object listener) {
        return AccessController.doPrivileged(new PrivilegedAction<CompletionStage<Void>>(){

            @Override
            public CompletionStage<Void> run() {
                return DefaultCacheContainer.super.addListenerAsync(listener);
            }
        });
    }

    public EmbeddedCacheManager startCaches(String ... cacheNames) {
        super.startCaches(cacheNames);
        return this;
    }

    public EmbeddedCacheManagerAdmin administration() {
        return this.administrator;
    }

    public synchronized <K, V> Cache<K, V> createCache(String name, Configuration configuration) {
        return this.administrator.createCache(name, configuration);
    }

    public EmbeddedCacheManager withSubject(Subject subject) {
        return new DefaultCacheContainer(this.cm.withSubject(subject), this.loader);
    }

    public boolean equals(Object object) {
        if (!(object instanceof EmbeddedCacheManager)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getCacheManagerConfiguration().cacheManagerName();
    }

    private static class DefaultCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        private final EmbeddedCacheManager manager;

        DefaultCache(EmbeddedCacheManager manager, Cache<K, V> cache) {
            this(manager, cache.getAdvancedCache());
        }

        DefaultCache(EmbeddedCacheManager manager, AdvancedCache<K, V> cache) {
            super(cache);
            this.manager = manager;
        }

        public EmbeddedCacheManager getCacheManager() {
            return this.manager;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Cache)) {
                return false;
            }
            Cache cache = (Cache)object;
            return this.manager.equals(cache.getCacheManager()) && this.getName().equals(cache.getName());
        }

        public int hashCode() {
            return this.cache.hashCode();
        }

        public AdvancedCache rewrap(AdvancedCache delegate) {
            return new DefaultCache<K, V>(this.manager, delegate);
        }

        public void addListener(final Object listener) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    DefaultCache.super.addListener(listener);
                    return null;
                }
            });
        }

        public CompletionStage<Void> addListenerAsync(final Object listener) {
            return AccessController.doPrivileged(new PrivilegedAction<CompletionStage<Void>>(){

                @Override
                public CompletionStage<Void> run() {
                    return DefaultCache.super.addListenerAsync(listener);
                }
            });
        }

        public <C> void addListener(final Object listener, final CacheEventFilter<? super K, ? super V> filter, final CacheEventConverter<? super K, ? super V, C> converter) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    DefaultCache.super.addListener(listener, filter, converter);
                    return null;
                }
            });
        }

        public <C> CompletionStage<Void> addListenerAsync(final Object listener, final CacheEventFilter<? super K, ? super V> filter, final CacheEventConverter<? super K, ? super V, C> converter) {
            return AccessController.doPrivileged(new PrivilegedAction<CompletionStage<Void>>(){

                @Override
                public CompletionStage<Void> run() {
                    return DefaultCache.super.addListenerAsync(listener, filter, converter);
                }
            });
        }

        public <C> void addFilteredListener(final Object listener, final CacheEventFilter<? super K, ? super V> filter, final CacheEventConverter<? super K, ? super V, C> converter, final Set<Class<? extends Annotation>> filterAnnotations) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    DefaultCache.super.addFilteredListener(listener, filter, converter, filterAnnotations);
                    return null;
                }
            });
        }

        public <C> CompletionStage<Void> addFilteredListenerAsync(final Object listener, final CacheEventFilter<? super K, ? super V> filter, final CacheEventConverter<? super K, ? super V, C> converter, final Set<Class<? extends Annotation>> filterAnnotations) {
            return AccessController.doPrivileged(new PrivilegedAction<CompletionStage<Void>>(){

                @Override
                public CompletionStage<Void> run() {
                    return DefaultCache.super.addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
                }
            });
        }

        public <C> void addStorageFormatFilteredListener(final Object listener, final CacheEventFilter<? super K, ? super V> filter, final CacheEventConverter<? super K, ? super V, C> converter, final Set<Class<? extends Annotation>> filterAnnotations) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Void run() {
                    DefaultCache.super.addStorageFormatFilteredListener(listener, filter, converter, filterAnnotations);
                    return null;
                }
            });
        }

        public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(final Object listener, final CacheEventFilter<? super K, ? super V> filter, final CacheEventConverter<? super K, ? super V, C> converter, final Set<Class<? extends Annotation>> filterAnnotations) {
            return AccessController.doPrivileged(new PrivilegedAction<CompletionStage<Void>>(){

                @Override
                public CompletionStage<Void> run() {
                    return DefaultCache.super.addStorageFormatFilteredListenerAsync(listener, filter, converter, filterAnnotations);
                }
            });
        }
    }
}

