/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.io;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.xnio.Option;
import org.xnio.OptionMap;

public class OptionAttributeDefinition
extends SimpleAttributeDefinition {
    private final Option option;
    private final Class<?> optionType;

    private OptionAttributeDefinition(Builder builder, Option<?> option, Class<?> optionType) {
        super((AbstractAttributeDefinitionBuilder)builder);
        this.option = option;
        this.optionType = optionType;
    }

    public Option<?> getOption() {
        return this.option;
    }

    public Class<?> getOptionType() {
        return this.optionType;
    }

    public OptionMap.Builder resolveOption(ExpressionResolver context, ModelNode model, OptionMap.Builder builder) throws OperationFailedException {
        ModelNode value = this.resolveModelAttribute(context, model);
        if (value.isDefined()) {
            if (this.getType() == ModelType.INT) {
                builder.set(this.option, value.asInt());
            } else if (this.getType() == ModelType.LONG) {
                builder.set(this.option, value.asLong());
            } else if (this.getType() == ModelType.BOOLEAN) {
                builder.set(this.option, value.asBoolean());
            } else if (this.optionType.isEnum()) {
                builder.set(this.option, this.option.parseValue(value.asString(), this.option.getClass().getClassLoader()));
            } else if (this.option.getClass().getSimpleName().equals("SequenceOption")) {
                builder.setSequence(this.option, (Object[])value.asString().split("\\s*,\\s*"));
            } else if (this.getType() == ModelType.STRING) {
                builder.set(this.option, (Object)value.asString());
            } else {
                throw new OperationFailedException("Don't know how to handle: " + this.option + " with value: " + value);
            }
        }
        return builder;
    }

    public static Builder builder(String attributeName, Option<?> option) {
        return new Builder(attributeName, option);
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, OptionAttributeDefinition> {
        private Option<?> option;
        private Class<?> optionType;

        public Builder(String attributeName, Option<?> option) {
            this(attributeName, option, null);
        }

        public Builder(String attributeName, Option<?> option, ModelNode defaultValue) {
            super(attributeName, Builder.determineModelType(option), true);
            this.option = option;
            this.optionType = Builder.determineOptionType(option);
            this.setDefaultValue(defaultValue);
        }

        public OptionAttributeDefinition build() {
            return new OptionAttributeDefinition(this, this.option, this.optionType);
        }

        private static ModelType determineModelType(Option<?> option) {
            Class<Object> optionType = Builder.determineOptionType(option);
            if (optionType.isAssignableFrom(Integer.class)) {
                return ModelType.INT;
            }
            if (optionType.isAssignableFrom(Long.class)) {
                return ModelType.LONG;
            }
            if (optionType.isAssignableFrom(BigInteger.class)) {
                return ModelType.BIG_INTEGER;
            }
            if (optionType.isAssignableFrom(Double.class)) {
                return ModelType.DOUBLE;
            }
            if (optionType.isAssignableFrom(BigDecimal.class)) {
                return ModelType.BIG_DECIMAL;
            }
            if (optionType.isEnum() || optionType.isAssignableFrom(String.class)) {
                return ModelType.STRING;
            }
            if (optionType.isAssignableFrom(Boolean.class)) {
                return ModelType.BOOLEAN;
            }
            return ModelType.UNDEFINED;
        }

        private static Class<?> determineOptionType(Option<?> option) {
            try {
                Field typeField = option.getClass().getSimpleName().equals("SequenceOption") ? option.getClass().getDeclaredField("elementType") : option.getClass().getDeclaredField("type");
                typeField.setAccessible(true);
                Class optionType = (Class)typeField.get(option);
                return optionType;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

