/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.batch;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.batch.AbstractContextualBatch;
import org.wildfly.clustering.cache.infinispan.batch.ThreadContextBatch;
import org.wildfly.clustering.cache.infinispan.batch.Transactional;
import org.wildfly.clustering.cache.infinispan.batch.TransactionalBatch;
import org.wildfly.clustering.cache.infinispan.batch.TransactionalSuspendedBatch;
import org.wildfly.clustering.function.Consumer;

public class DefaultTransactionalBatch
extends AbstractContextualBatch
implements TransactionalBatch,
TransactionalSuspendedBatch,
Synchronization {
    private final TransactionManager tm;
    private final Transaction tx;
    private final Batch.Status status;
    private final Function<Exception, RuntimeException> exceptionTransformer;
    private final AtomicBoolean active;

    DefaultTransactionalBatch(String name, TransactionManager tm, Function<Exception, RuntimeException> exceptionTransformer) {
        this(name, tm, DefaultTransactionalBatch.begin(tm, exceptionTransformer), exceptionTransformer, new AtomicBoolean(true));
    }

    DefaultTransactionalBatch(String name, TransactionManager tm, final Transaction tx, final Function<Exception, RuntimeException> exceptionTransformer, final AtomicBoolean active) {
        super(name, (Consumer<Batch.Status>)((Consumer)status -> {
            try {
                switch (tx.getStatus()) {
                    case 0: {
                        if (status.isActive()) {
                            try {
                                LOGGER.log(System.Logger.Level.DEBUG, "Committing batch {0}", tx);
                                tx.commit();
                                LOGGER.log(System.Logger.Level.DEBUG, "Committed batch {0}", tx);
                                break;
                            }
                            catch (RollbackException e) {
                                throw new IllegalStateException(e);
                            }
                            catch (HeuristicMixedException | HeuristicRollbackException e) {
                                throw (RuntimeException)exceptionTransformer.apply((Exception)e);
                            }
                        }
                    }
                    case 1: {
                        LOGGER.log(System.Logger.Level.DEBUG, "Rolling back batch {0}", tx);
                        tx.rollback();
                        LOGGER.log(System.Logger.Level.DEBUG, "Rolled back batch {0}", tx);
                        break;
                    }
                    default: {
                        LOGGER.log(System.Logger.Level.DEBUG, "Closed batch {0} with status = {2}", tx, tx.getStatus());
                        break;
                    }
                }
            }
            catch (SystemException e) {
                throw (RuntimeException)exceptionTransformer.apply((Exception)((Object)e));
            }
        }));
        this.tm = tm;
        this.tx = tx;
        this.exceptionTransformer = exceptionTransformer;
        this.active = active;
        this.status = new Batch.Status(){

            public boolean isActive() {
                int status = this.getStatus();
                return status == 0 && active.get();
            }

            public boolean isDiscarding() {
                int status = this.getStatus();
                return status == 0 && !active.get() || status == 1;
            }

            public boolean isClosed() {
                int status = this.getStatus();
                return status != 0 && status != 1;
            }

            private int getStatus() {
                try {
                    return tx.getStatus();
                }
                catch (SystemException e) {
                    throw (RuntimeException)exceptionTransformer.apply(e);
                }
            }
        };
        try {
            tx.registerSynchronization((Synchronization)this);
        }
        catch (RollbackException | SystemException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Transaction begin(TransactionManager tm, Function<Exception, RuntimeException> exceptionTransformer) {
        try {
            Transaction currentTx = tm.getTransaction();
            if (currentTx != null) {
                throw new IllegalStateException(currentTx.toString());
            }
            tm.begin();
            return tm.getTransaction();
        }
        catch (NotSupportedException | SystemException e) {
            throw exceptionTransformer.apply((Exception)e);
        }
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    @Override
    public Transaction getTransaction() {
        return this.tx;
    }

    public Batch.Status getStatus() {
        return this.status;
    }

    @Override
    public TransactionalSuspendedBatch suspend() {
        LOGGER.log(System.Logger.Level.DEBUG, "Suspending batch {0}", this);
        try {
            Transaction suspendedTx = this.tm.suspend();
            if (suspendedTx != this.tx) {
                throw new IllegalStateException(this.tx.toString());
            }
            return this;
        }
        catch (SystemException e) {
            throw this.exceptionTransformer.apply((Exception)((Object)e));
        }
    }

    @Override
    public TransactionalBatch resume() {
        try {
            Batch.LOGGER.log(System.Logger.Level.DEBUG, "Resuming batch {0}", this);
            this.tm.resume(this.tx);
            return this;
        }
        catch (InvalidTransactionException | SystemException e) {
            throw this.exceptionTransformer.apply((Exception)e);
        }
    }

    public void discard() {
        this.active.set(false);
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        ThreadContextBatch.INSTANCE.accept(null);
    }

    public int hashCode() {
        return this.getTransaction().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Transactional)) {
            return false;
        }
        Transactional batch = (Transactional)object;
        return this.getTransaction().equals((Object)batch.getTransaction());
    }

    public String toString() {
        return Map.of("context", this.getName(), "tx", this.getTransaction()).toString();
    }
}

