/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import org.jboss.as.clustering.jgroups.subsystem.AbstractTransportResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.BasicTCP;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.service.Dependency;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ServiceDependency;

public class SocketTransportResourceDefinitionRegistrar<T extends BasicTCP>
extends AbstractTransportResourceDefinitionRegistrar<T> {
    static final CapabilityReferenceAttributeDefinition<SocketBinding> CLIENT_SOCKET_BINDING = ((CapabilityReferenceAttributeDefinition.Builder)((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("client-socket-binding", CapabilityReference.builder((RuntimeCapability)CAPABILITY, (UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR).build()).setRequired(false)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).build();

    SocketTransportResourceDefinitionRegistrar(final Transport registration, final ResourceOperationRuntimeHandler parentRuntimeHandler) {
        super(new AbstractTransportResourceDefinitionRegistrar.Configurator(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return registration;
            }

            @Override
            public ResourceOperationRuntimeHandler getParentRuntimeHandler() {
                return parentRuntimeHandler;
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(CLIENT_SOCKET_BINDING));
    }

    @Override
    public ServiceDependency<TransportConfiguration<T>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        String stackName = context.getCurrentAddress().getParent().getLastElement().getValue();
        final boolean hasSocketBasedFailureDetectionProtocol = EnumSet.allOf(SocketProtocolResourceRegistration.class).stream().map(Enum::name).anyMatch(fd -> context.hasOptionalCapability(ProtocolConfiguration.SERVICE_DESCRIPTOR, stackName, fd, CAPABILITY, null));
        ServiceDependency clientSocketBinding = CLIENT_SOCKET_BINDING.resolve(context, model);
        return super.resolve(context, model).combine((Dependency)clientSocketBinding, new BiFunction<TransportConfiguration<T>, SocketBinding, TransportConfiguration<T>>(){

            @Override
            public TransportConfiguration<T> apply(TransportConfiguration<T> configuration, final SocketBinding clientSocketBinding) {
                return new AbstractTransportResourceDefinitionRegistrar.TransportConfigurationDecorator<T>(configuration){

                    @Override
                    public T createProtocol(ChannelFactoryConfiguration stackConfiguration) {
                        BasicTCP transport = (BasicTCP)super.createProtocol(stackConfiguration);
                        if (clientSocketBinding != null) {
                            InetSocketAddress clientSocketAddress = clientSocketBinding.getSocketAddress();
                            this.setValue(transport, "client_bind_addr", clientSocketAddress.getAddress());
                            this.setValue(transport, "client_bind_port", clientSocketAddress.getPort());
                        }
                        if (!hasSocketBasedFailureDetectionProtocol && transport.getReaperInterval() <= 0L && transport.getConnExpireTime() <= 0L) {
                            transport.enableSuspectEvents(true);
                        }
                        return transport;
                    }

                    @Override
                    public Map<String, SocketBinding> getSocketBindings() {
                        Map<String, SocketBinding> bindings = super.getSocketBindings();
                        if (clientSocketBinding != null) {
                            bindings = new TreeMap<String, SocketBinding>(bindings);
                            for (String serviceName : Set.of("jgroups.tcp.sock", "jgroups.nio.client")) {
                                bindings.put(serviceName, clientSocketBinding);
                            }
                        }
                        return bindings;
                    }
                };
            }
        });
    }

    static enum Transport implements ResourceRegistration
    {
        TCP,
        TCP_NIO2;

        private final PathElement path = StackResourceDefinitionRegistrar.Component.TRANSPORT.pathElement(this.name());

        public PathElement getPathElement() {
            return this.path;
        }
    }
}

