/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleListAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.registry.CapabilityId;
import org.jboss.as.controller.capability.registry.CapabilityRegistration;
import org.jboss.as.controller.capability.registry.CapabilityScope;
import org.jboss.as.controller.capability.registry.ImmutableCapabilityRegistry;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CapabilityRegistryResourceDefinition
extends SimpleResourceDefinition {
    private static final SimpleListAttributeDefinition DEPENDENT_ADDRESS = new SimpleListAttributeDefinition.Builder("dependent-address", (AttributeDefinition)new SimpleAttributeDefinitionBuilder("parameter", ModelType.PROPERTY, false).build()).build();
    private static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"name", (ModelType)ModelType.STRING).setRequired(true)).build();
    private static final StringListAttributeDefinition REGISTRATION_POINTS = new StringListAttributeDefinition.Builder("registration-points").build();
    private static final SimpleAttributeDefinition DYNAMIC = SimpleAttributeDefinitionBuilder.create((String)"dynamic", (ModelType)ModelType.BOOLEAN, (boolean)false).build();
    private static final SimpleAttributeDefinition SCOPE = SimpleAttributeDefinitionBuilder.create((String)"scope", (ModelType)ModelType.STRING, (boolean)true).build();
    private static final ObjectTypeAttributeDefinition CAPABILITY = new ObjectTypeAttributeDefinition.Builder("capability", new AttributeDefinition[]{NAME, DYNAMIC, SCOPE, REGISTRATION_POINTS}).build();
    private static final ObjectListAttributeDefinition CAPABILITIES = new ObjectListAttributeDefinition.Builder("capabilities", CAPABILITY).build();
    private static final ObjectTypeAttributeDefinition POSSIBLE_CAPABILITY = new ObjectTypeAttributeDefinition.Builder("possible-capability", new AttributeDefinition[]{NAME, DYNAMIC, REGISTRATION_POINTS}).build();
    private static final ObjectListAttributeDefinition POSSIBLE_CAPABILITIES = new ObjectListAttributeDefinition.Builder("possible-capabilities", POSSIBLE_CAPABILITY).build();
    private static final OperationDefinition GET_PROVIDER_POINTS = new SimpleOperationDefinitionBuilder("get-provider-points", ServerDescriptions.getResourceDescriptionResolver("core", "capability-registry")).addParameter((AttributeDefinition)NAME).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    private static final OperationDefinition GET_CAPABILITY = new SimpleOperationDefinitionBuilder("get-capability", ServerDescriptions.getResourceDescriptionResolver("core", "capability-registry")).addParameter((AttributeDefinition)NAME).addParameter((AttributeDefinition)SCOPE).setReadOnly().setRuntimeOnly().setReplyParameters(new AttributeDefinition[]{CAPABILITY}).build();
    private static final OperationDefinition SUGGEST_CAPABILITIES = new SimpleOperationDefinitionBuilder("suggest-capabilities", ServerDescriptions.getResourceDescriptionResolver("core", "capability-registry")).addParameter((AttributeDefinition)NAME).addParameter((AttributeDefinition)DEPENDENT_ADDRESS).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    private final ImmutableCapabilityRegistry capabilityRegistry;

    public CapabilityRegistryResourceDefinition(ImmutableCapabilityRegistry capabilityRegistry) {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"core-service", (String)"capability-registry"), ServerDescriptions.getResourceDescriptionResolver("core", "capability-registry")).setRuntime());
        assert (capabilityRegistry != null);
        this.capabilityRegistry = capabilityRegistry;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)POSSIBLE_CAPABILITIES, (context, operation) -> CapabilityRegistryResourceDefinition.populateCapabilities(this.capabilityRegistry.getPossibleCapabilities(), context.getResult(), true));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CAPABILITIES, (context, operation) -> CapabilityRegistryResourceDefinition.populateCapabilities(this.capabilityRegistry.getCapabilities(), context.getResult(), false));
    }

    private static void populateRegistrationPoints(ModelNode points, Set<RegistrationPoint> registrationPoints) {
        for (RegistrationPoint point : registrationPoints) {
            points.add(point.getAddress().toCLIStyleString());
        }
    }

    private static void populateCapabilities(Set<CapabilityRegistration<?>> caps, ModelNode res, boolean possible) {
        for (CapabilityRegistration<?> cr : caps) {
            ModelNode cap = res.add();
            cap.get(NAME.getName()).set(cr.getCapabilityName());
            cap.get(DYNAMIC.getName()).set(cr.getCapability().isDynamicallyNamed());
            if (!possible) {
                cap.get(SCOPE.getName()).set(cr.getCapabilityScope().getName());
            }
            CapabilityRegistryResourceDefinition.populateRegistrationPoints(cap.get(REGISTRATION_POINTS.getName()), cr.getRegistrationPoints());
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(GET_PROVIDER_POINTS, (context, operation) -> {
            ModelNode model = new ModelNode();
            NAME.validateAndSet(operation, model);
            String name = NAME.resolveModelAttribute(context, model).asString();
            CapabilityId id = new CapabilityId(name, CapabilityScope.GLOBAL);
            Set providerPoints = this.capabilityRegistry.getPossibleProviderPoints(id);
            for (PathAddress point : providerPoints) {
                context.getResult().add(point.toCLIStyleString());
            }
        });
        resourceRegistration.registerOperationHandler(GET_CAPABILITY, (context, operation) -> {
            CapabilityScope scope;
            ModelNode model = new ModelNode();
            NAME.validateAndSet(operation, model);
            SCOPE.validateAndSet(operation, model);
            String name = NAME.resolveModelAttribute(context, model).asString();
            if (model.hasDefined(SCOPE.getName())) {
                String scopeName = SCOPE.resolveModelAttribute(context, model).asString();
                scope = CapabilityScope.Factory.forName((String)scopeName);
            } else {
                scope = CapabilityScope.GLOBAL;
            }
            CapabilityId id = new CapabilityId(name, scope);
            CapabilityRegistration reg = this.capabilityRegistry.getCapability(id);
            if (reg != null) {
                ModelNode result = context.getResult();
                this.populateCapabilityRegistration(reg, result);
            }
        });
        resourceRegistration.registerOperationHandler(SUGGEST_CAPABILITIES, (context, operation) -> {
            String name = NAME.resolveModelAttribute(context, operation).asString();
            PathAddress address = PathAddress.pathAddress((ModelNode)DEPENDENT_ADDRESS.resolveModelAttribute(context, operation));
            CapabilityScope dependentScope = CapabilityScope.Factory.create((ProcessType)context.getProcessType(), (PathAddress)address);
            Set capabilities = this.capabilityRegistry.getDynamicCapabilityNames(name, dependentScope);
            for (String capability : capabilities) {
                context.getResult().add(capability);
            }
        });
    }

    private void populateCapabilityRegistration(CapabilityRegistration reg, ModelNode capability) {
        CapabilityRegistryResourceDefinition.populateRegistrationPoints(capability.get(REGISTRATION_POINTS.getName()), reg.getRegistrationPoints());
    }
}

