/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.moduleservice;

import java.util.function.Consumer;
import org.jboss.as.controller.UninterruptibleCountDownLatch;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.Services;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ModuleDefinition;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.Service;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class ServiceModuleLoader
extends ModuleLoader
implements org.jboss.msc.service.Service<ServiceModuleLoader> {
    private static final ServerLogger log = ServerLogger.MODULE_SERVICE_LOGGER;
    public static final ServiceName MODULE_SPEC_SERVICE_PREFIX = ServiceName.JBOSS.append(new String[]{"module", "spec", "service"});
    public static final ServiceName MODULE_SERVICE_PREFIX = ServiceName.JBOSS.append(new String[]{"module", "service"});
    public static final ServiceName MODULE_RESOLVED_SERVICE_PREFIX = ServiceName.of((String[])new String[]{"module", "resolved", "service"});
    public static final String MODULE_PREFIX = "deployment.";
    private final ModuleLoader mainModuleLoader;
    private volatile ServiceContainer serviceContainer;

    public ServiceModuleLoader(ModuleLoader mainModuleLoader) {
        this.mainModuleLoader = mainModuleLoader;
    }

    protected Module preloadModule(String name) throws ModuleLoadException {
        if (name.startsWith(MODULE_PREFIX)) {
            return super.preloadModule(name);
        }
        return ServiceModuleLoader.preloadModule((String)name, (ModuleLoader)this.mainModuleLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModuleSpec findModule(String identifier) throws ModuleLoadException {
        ServiceController controller = this.serviceContainer.getService(ServiceModuleLoader.moduleSpecServiceName(identifier));
        if (controller == null) {
            ServerLogger.MODULE_SERVICE_LOGGER.debugf("Could not load module '%s' as corresponding module spec service '%s' was not found", identifier, identifier);
            return null;
        }
        UninterruptibleCountDownLatch latch = new UninterruptibleCountDownLatch(1);
        ModuleSpecLoadListener listener = new ModuleSpecLoadListener(latch);
        try {
            ServiceController serviceController = controller;
            synchronized (serviceController) {
                ServiceController.State state = controller.getState();
                if (state == ServiceController.State.UP || state == ServiceController.State.START_FAILED) {
                    listener.done(controller, controller.getStartException());
                }
            }
            controller.addListener((LifecycleListener)listener);
        }
        finally {
            latch.countDown();
        }
        return listener.getModuleSpec();
    }

    public String toString() {
        return "Service Module Loader";
    }

    public void start(StartContext context) throws StartException {
        if (this.serviceContainer != null) {
            throw ServerLogger.ROOT_LOGGER.serviceModuleLoaderAlreadyStarted();
        }
        this.serviceContainer = context.getController().getServiceContainer();
    }

    public void stop(StopContext context) {
        if (this.serviceContainer == null) {
            throw ServerLogger.ROOT_LOGGER.serviceModuleLoaderAlreadyStopped();
        }
        this.serviceContainer = null;
    }

    public ServiceModuleLoader getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void relinkModule(Module module) throws ModuleLoadException {
        this.relink(module);
    }

    public static void addService(ServiceTarget serviceTarget, Bootstrap.Configuration configuration) {
        ServiceModuleLoader service = new ServiceModuleLoader(configuration.getModuleLoader());
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_SERVICE_MODULE_LOADER, (org.jboss.msc.service.Service)service);
        serviceBuilder.install();
    }

    public static ServiceName moduleSpecServiceName(String identifier) {
        if (!ServiceModuleLoader.isDynamicModule(identifier)) {
            throw ServerLogger.ROOT_LOGGER.missingModulePrefix(identifier, MODULE_PREFIX);
        }
        return MODULE_SPEC_SERVICE_PREFIX.append(new String[]{identifier});
    }

    public static void installModuleResolvedService(ServiceTarget serviceTarget, String identifier) {
        ServiceName sn = ServiceModuleLoader.moduleResolvedServiceName(identifier);
        ServiceBuilder sb = serviceTarget.addService(sn);
        Consumer moduleIdConsumer = sb.provides(new ServiceName[]{sn});
        sb.requires(ServiceModuleLoader.moduleSpecServiceName(identifier));
        Service resolvedService = Service.newInstance((Consumer)moduleIdConsumer, (Object)identifier);
        sb.setInstance(resolvedService);
        sb.install();
    }

    public static ServiceName moduleResolvedServiceName(String identifier) {
        if (!ServiceModuleLoader.isDynamicModule(identifier)) {
            throw ServerLogger.ROOT_LOGGER.missingModulePrefix(identifier, MODULE_PREFIX);
        }
        return MODULE_RESOLVED_SERVICE_PREFIX.append(new String[]{identifier});
    }

    public static boolean isDynamicModule(String identifier) {
        return identifier.startsWith(MODULE_PREFIX);
    }

    public static ServiceName moduleServiceName(String identifier) {
        if (!identifier.startsWith(MODULE_PREFIX)) {
            throw ServerLogger.ROOT_LOGGER.missingModulePrefix(identifier, MODULE_PREFIX);
        }
        return MODULE_SERVICE_PREFIX.append(new String[]{identifier});
    }

    private class ModuleSpecLoadListener
    implements LifecycleListener {
        private final UninterruptibleCountDownLatch latch;
        private volatile StartException startException;
        private volatile ModuleSpec moduleSpec;

        private ModuleSpecLoadListener(UninterruptibleCountDownLatch latch) {
            this.latch = latch;
        }

        public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
            this.latch.awaitUninterruptibly();
            switch (event) {
                case UP: {
                    log.tracef("serviceStarted: %s", controller);
                    this.done(controller, null);
                    break;
                }
                case FAILED: {
                    log.tracef((Throwable)controller.getStartException(), "serviceFailed: %s", controller);
                    this.done(controller, controller.getStartException());
                    break;
                }
                case DOWN: {
                    String identifier;
                    Module module;
                    log.tracef("serviceStopping: %s", controller);
                    ModuleSpec moduleSpec = this.moduleSpec;
                    if (moduleSpec != null && (module = ServiceModuleLoader.this.findLoadedModuleLocal(identifier = moduleSpec.getName())) != null) {
                        ServiceModuleLoader.this.unloadModuleLocal(identifier, module);
                    }
                    controller.removeListener((LifecycleListener)this);
                    break;
                }
            }
        }

        private void done(ServiceController<?> controller, StartException reason) {
            this.startException = reason;
            if (this.startException == null) {
                this.moduleSpec = ((ModuleDefinition)controller.getValue()).getModuleSpec();
            }
        }

        public ModuleSpec getModuleSpec() throws ModuleLoadException {
            if (this.startException != null) {
                throw new ModuleLoadException(this.startException.getCause());
            }
            return this.moduleSpec;
        }
    }
}

