/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.server.handlers.builder.PredicatedHandler;
import io.undertow.server.handlers.builder.PredicatedHandlersParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.HttpHandlerMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.undertow.deployment.ConfiguredHandlerWrapper;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class UndertowHandlersDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String WEB_INF = "WEB-INF/undertow-handlers.conf";
    private static final String META_INF = "META-INF/undertow-handlers.conf";
    public static final AttachmentKey<List<PredicatedHandler>> PREDICATED_HANDLERS = AttachmentKey.create(List.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            return;
        }
        this.handleInfoFile(deploymentUnit, module);
        this.handleJbossWebXml(deploymentUnit, module);
    }

    private void handleJbossWebXml(DeploymentUnit deploymentUnit, Module module) throws DeploymentUnitProcessingException {
        WarMetaData warMetadata = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetadata == null) {
            return;
        }
        JBossWebMetaData merged = warMetadata.getMergedJBossWebMetaData();
        if (merged == null) {
            return;
        }
        List handlers = merged.getHandlers();
        if (handlers == null) {
            return;
        }
        for (HttpHandlerMetaData hander : handlers) {
            try {
                ModuleClassLoader cl = module.getClassLoader();
                if (hander.getModule() != null) {
                    Module handlerModule = ((ServiceModuleLoader)deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER)).loadModule(ModuleIdentifierUtil.parseCanonicalModuleIdentifier((String)hander.getModule()));
                    cl = handlerModule.getClassLoader();
                }
                Class<?> handlerClass = cl.loadClass(hander.getHandlerClass());
                HashMap<String, String> params = new HashMap<String, String>();
                if (hander.getParams() != null) {
                    for (ParamValueMetaData param : hander.getParams()) {
                        params.put(param.getParamName(), param.getParamValue());
                    }
                }
                deploymentUnit.addToAttachmentList(UndertowAttachments.UNDERTOW_OUTER_HANDLER_CHAIN_WRAPPERS, (Object)new ConfiguredHandlerWrapper(handlerClass, params));
            }
            catch (Exception e) {
                throw UndertowLogger.ROOT_LOGGER.failedToConfigureHandlerClass(hander.getHandlerClass(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInfoFile(DeploymentUnit deploymentUnit, Module module) {
        ArrayList handlerWrappers = new ArrayList();
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            VirtualFile config = root.getRoot().getChild(WEB_INF);
            try {
                if (config.exists()) {
                    handlerWrappers.addAll(PredicatedHandlersParser.parse((InputStream)config.openStream(), (ClassLoader)module.getClassLoader()));
                }
                Enumeration paths = module.getClassLoader().getResources(META_INF);
                while (paths.hasMoreElements()) {
                    URL path = (URL)paths.nextElement();
                    handlerWrappers.addAll(PredicatedHandlersParser.parse((InputStream)path.openStream(), (ClassLoader)module.getClassLoader()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!handlerWrappers.isEmpty()) {
                deploymentUnit.putAttachment(PREDICATED_HANDLERS, handlerWrappers);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

