/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;
import org.jboss.resteasy.microprofile.client.SecurityActions;

public class RestClientListeners {
    private static final Map<ClassLoader, Collection<RestClientListener>> map = Collections.synchronizedMap(new WeakHashMap());

    private RestClientListeners() {
    }

    public static Collection<RestClientListener> get() {
        ClassLoader loader = SecurityActions.getClassLoader(RestClientListeners.class);
        if (loader == null) {
            return Collections.emptyList();
        }
        PrivilegedAction<Collection> action = () -> ServiceLoader.load(RestClientListener.class, loader).stream().map(ServiceLoader.Provider::get).collect(Collectors.toUnmodifiableList());
        return map.computeIfAbsent(loader, classLoader -> {
            if (System.getSecurityManager() == null) {
                return (Collection)action.run();
            }
            return (Collection)AccessController.doPrivileged(action);
        });
    }
}

