/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ModuleAttributeDefinition;
import org.jboss.as.clustering.controller.StatisticsEnabledAttributeDefinition;
import org.jboss.as.clustering.jgroups.subsystem.AbstractChannelResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetric;
import org.jboss.as.clustering.jgroups.subsystem.ChannelMetricExecutor;
import org.jboss.as.clustering.jgroups.subsystem.ForkResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.jgroups.JChannel;
import org.wildfly.clustering.jgroups.spi.ChannelConfiguration;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ForkChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.JGroupsServiceDescriptor;
import org.wildfly.clustering.server.service.ChannelServiceInstallerProvider;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.LegacyClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.ProvidedUnaryServiceInstallerProvider;
import org.wildfly.service.Dependency;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.executor.MetricExecutor;
import org.wildfly.subsystem.resource.executor.MetricOperationStepHandler;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;

public class ChannelResourceDefinitionRegistrar
extends AbstractChannelResourceDefinitionRegistrar<ChannelConfiguration> {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ChannelConfiguration.SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).build();
    static final CapabilityReferenceAttributeDefinition<ChannelFactory> STACK = new CapabilityReferenceAttributeDefinition.Builder("stack", CapabilityReference.builder(CAPABILITY, (UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR).build()).build();
    static final ModuleAttributeDefinition MODULE = ((ModuleAttributeDefinition.Builder)((ModuleAttributeDefinition.Builder)new ModuleAttributeDefinition.Builder().setRequired(false)).setDefaultValue(new ModelNode("org.wildfly.clustering.server"))).build();
    static final AttributeDefinition CLUSTER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cluster", ModelType.STRING).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final StatisticsEnabledAttributeDefinition STATISTICS_ENABLED = new StatisticsEnabledAttributeDefinition.Builder().build();
    private final ServiceValueExecutorRegistry<JChannel> channelRegistry;

    ChannelResourceDefinitionRegistrar() {
        this((ServiceValueExecutorRegistry<JChannel>)ServiceValueExecutorRegistry.newInstance());
    }

    private ChannelResourceDefinitionRegistrar(ServiceValueExecutorRegistry<JChannel> channelRegistry) {
        super(new AbstractChannelResourceDefinitionRegistrar.Configurator<ChannelConfiguration>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return JGroupsResourceRegistration.CHANNEL;
            }

            @Override
            public RuntimeCapability<Void> getCapability() {
                return CAPABILITY;
            }

            @Override
            public ResourceModelResolver<ServiceDependency<ForkChannelFactoryConfiguration>> getForkChannelFactoryConfigurationResolver() {
                return new ResourceModelResolver<ServiceDependency<ForkChannelFactoryConfiguration>>(){

                    public ServiceDependency<ForkChannelFactoryConfiguration> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
                        String name = context.getCurrentAddressValue();
                        return ServiceDependency.on((UnaryServiceDescriptor)JGroupsServiceDescriptor.CHANNEL, (String)name).combine((Dependency)ServiceDependency.on((UnaryServiceDescriptor)ChannelConfiguration.SERVICE_DESCRIPTOR, (String)name), (BiFunction)new BiFunction<JChannel, ChannelConfiguration, ForkChannelFactoryConfiguration>(){

                            @Override
                            public ForkChannelFactoryConfiguration apply(final JChannel channel, final ChannelConfiguration configuration) {
                                return new ForkChannelFactoryConfiguration(){

                                    public JChannel getChannel() {
                                        return channel;
                                    }

                                    public ChannelConfiguration getChannelConfiguration() {
                                        return configuration;
                                    }
                                };
                            }
                        });
                    }
                };
            }

            @Override
            public ResourceModelResolver<ServiceDependency<ChannelConfiguration>> getChannelConfigurationResolver() {
                return new ResourceModelResolver<ServiceDependency<ChannelConfiguration>>(){

                    public ServiceDependency<ChannelConfiguration> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
                        String name = context.getCurrentAddressValue();
                        final String clusterName = CLUSTER.resolveModelAttribute(context, model).asString(name);
                        final boolean statisticsEnabled = STATISTICS_ENABLED.resolve(context, model);
                        return STACK.resolve(context, model).combine((Dependency)MODULE.resolve(context, model), (BiFunction)new BiFunction<ChannelFactory, Module, ChannelConfiguration>(){

                            @Override
                            public ChannelConfiguration apply(final ChannelFactory factory, final Module module) {
                                return new ChannelConfiguration(){

                                    public boolean isStatisticsEnabled() {
                                        return statisticsEnabled;
                                    }

                                    public ChannelFactory getChannelFactory() {
                                        return factory;
                                    }

                                    public Module getModule() {
                                        return module;
                                    }

                                    public String getClusterName() {
                                        return clusterName;
                                    }
                                };
                            }
                        });
                    }
                };
            }

            @Override
            public ResourceModelResolver<PathAddress> getStackAddressResolver() {
                return new ResourceModelResolver<PathAddress>(){

                    public PathAddress resolve(OperationContext context, ModelNode model) throws OperationFailedException {
                        String stack = STACK.resolveModelAttribute(context, model).asString();
                        return context.getCurrentAddress().getParent().append(new PathElement[]{JGroupsResourceRegistration.STACK.pathElement(stack)});
                    }
                };
            }

            @Override
            public UnaryOperator<OperationStepHandler> getAddOperationTransformation() {
                return new UnaryOperator<OperationStepHandler>(){

                    @Override
                    public OperationStepHandler apply(final OperationStepHandler handler) {
                        return new OperationStepHandler(){

                            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                if (!operation.hasDefined(STACK.getName())) {
                                    PathAddress subsystemAddress = context.getCurrentAddress().getParent();
                                    Resource root = context.readResourceFromRoot(subsystemAddress.getParent(), false);
                                    if (!root.hasChild(subsystemAddress.getLastElement())) {
                                        context.addStep(operation, (OperationStepHandler)this, context.getCurrentStage());
                                        return;
                                    }
                                    Resource subsystem = context.readResourceFromRoot(subsystemAddress, false);
                                    ModelNode subsystemModel = subsystem.getModel();
                                    if (subsystemModel.hasDefined(JGroupsSubsystemResourceDefinitionRegistrar.DEFAULT_CHANNEL.getName())) {
                                        String defaultChannel = subsystemModel.get(JGroupsSubsystemResourceDefinitionRegistrar.DEFAULT_CHANNEL.getName()).asString();
                                        if (!context.getCurrentAddressValue().equals(defaultChannel)) {
                                            PathElement defaultChannelPath = JGroupsResourceRegistration.CHANNEL.pathElement(defaultChannel);
                                            if (!subsystem.hasChild(defaultChannelPath)) {
                                                context.addStep(operation, (OperationStepHandler)this, context.getCurrentStage());
                                                return;
                                            }
                                            Resource channel = context.readResourceFromRoot(subsystemAddress.append(new PathElement[]{defaultChannelPath}), false);
                                            ModelNode channelModel = channel.getModel();
                                            String defaultStack = channelModel.get(STACK.getName()).asString();
                                            operation.get(STACK.getName()).set(defaultStack);
                                        }
                                    }
                                }
                                handler.execute(context, operation);
                            }
                        };
                    }
                };
            }
        }, channelRegistry);
        this.channelRegistry = channelRegistry;
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        RuntimeCapability commandDispatcherFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).setAllowMultipleRegistrations(true).build();
        RuntimeCapability legacyCommandDispatcherFactory = RuntimeCapability.Builder.of((UnaryServiceDescriptor)LegacyClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).setAllowMultipleRegistrations(true).build();
        RuntimeCapability group = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.GROUP).setAllowMultipleRegistrations(true).build();
        RuntimeCapability legacyGroup = RuntimeCapability.Builder.of((UnaryServiceDescriptor)LegacyClusteringServiceDescriptor.GROUP).setAllowMultipleRegistrations(true).build();
        return (ResourceDescriptor.Builder)((ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(STACK, MODULE, CLUSTER, STATISTICS_ENABLED))).addCapabilities(List.of(commandDispatcherFactory, legacyCommandDispatcherFactory, group, legacyGroup));
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = super.register(parent, context);
        if (context.isRuntimeOnlyRegistrationValid()) {
            new MetricOperationStepHandler((MetricExecutor)new ChannelMetricExecutor((FunctionExecutorRegistry<JChannel>)this.channelRegistry), ChannelMetric.class).register(registration);
        }
        new ForkResourceDefinitionRegistrar(this.channelRegistry).register(registration, context);
        return registration;
    }

    @Override
    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        LinkedList<ResourceServiceInstaller> installers = new LinkedList<ResourceServiceInstaller>();
        installers.add(super.configure(context, model));
        new ProvidedUnaryServiceInstallerProvider(ChannelServiceInstallerProvider.class, ChannelServiceInstallerProvider.class.getClassLoader()).apply(name).forEach(installers::add);
        return ResourceServiceInstaller.combine(installers);
    }
}

