/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.function.Function;
import org.jboss.as.clustering.jgroups.subsystem.AbstractTransportResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.UDP;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ServiceDependency;

public class MulticastTransportResourceDefinitionRegistrar
extends AbstractTransportResourceDefinitionRegistrar<UDP> {
    MulticastTransportResourceDefinitionRegistrar(final Transport registration, final ResourceOperationRuntimeHandler parentRuntimeHandler) {
        super(new AbstractTransportResourceDefinitionRegistrar.Configurator(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return registration;
            }

            @Override
            public ResourceOperationRuntimeHandler getParentRuntimeHandler() {
                return parentRuntimeHandler;
            }
        });
    }

    @Override
    public ServiceDependency<TransportConfiguration<UDP>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        return super.resolve(context, model).map((Function)new Function<TransportConfiguration<UDP>, TransportConfiguration<UDP>>(){

            @Override
            public TransportConfiguration<UDP> apply(final TransportConfiguration<UDP> configuration) {
                return new AbstractTransportResourceDefinitionRegistrar.TransportConfigurationDecorator<UDP>(configuration){

                    @Override
                    public UDP createProtocol(ChannelFactoryConfiguration stackConfiguration) {
                        SocketBinding binding = configuration.getSocketBinding();
                        UDP transport = (UDP)super.createProtocol(stackConfiguration);
                        transport.setMulticasting(binding.getMulticastAddress() != null);
                        if (transport.supportsMulticasting()) {
                            transport.setMulticastAddress(binding.getMulticastAddress());
                            transport.setMulticastPort(binding.getMulticastPort());
                        }
                        return transport;
                    }
                };
            }
        });
    }

    static enum Transport implements ResourceRegistration
    {
        UDP;

        private final PathElement path = StackResourceDefinitionRegistrar.Component.TRANSPORT.pathElement(this.name());

        public PathElement getPathElement() {
            return this.path;
        }
    }
}

