/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.JChannel;
import org.jgroups.protocols.FORK;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.RemoteSiteConfiguration;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.AttributeDefinitionProvider;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ServiceDependency;

public class RelayResourceDefinitionRegistrar
extends ProtocolConfigurationResourceDefinitionRegistrar<RELAY2, RelayConfiguration> {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)RelayConfiguration.SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();

    RelayResourceDefinitionRegistrar(final ResourceOperationRuntimeHandler parentRuntimeHandler) {
        this(new ProtocolConfigurationResourceDefinitionRegistrar.Configurator(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return Protocol.RELAY2;
            }

            @Override
            public ResourceDescriptionResolver getResourceDescriptionResolver() {
                return JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(StackResourceDefinitionRegistrar.Component.RELAY.getPathElement(), StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement());
            }

            @Override
            public RuntimeCapability<Void> getCapability() {
                return CAPABILITY;
            }

            @Override
            public ResourceOperationRuntimeHandler getParentRuntimeHandler() {
                return parentRuntimeHandler;
            }
        });
    }

    private RelayResourceDefinitionRegistrar(ProtocolConfigurationResourceDefinitionRegistrar.Configurator configurator) {
        super(configurator);
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).provideAttributes(EnumSet.allOf(Attribute.class));
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = super.register(parent, context);
        new RemoteSiteResourceDefinitionRegistrar(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this)).register(registration, context);
        return registration;
    }

    public ServiceDependency<RelayConfiguration> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final ServiceDependency protocol = (ServiceDependency)this.resolver.resolve(context, model);
        String stackName = context.getCurrentAddress().getParent().getLastElement().getValue();
        final String siteName = Attribute.SITE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Set remoteSiteNames = resource.getChildrenNames(JGroupsResourceRegistration.REMOTE_SITE.getPathElement().getKey());
        final ArrayList<ServiceDependency> remoteSites = new ArrayList<ServiceDependency>(remoteSiteNames.size());
        for (String remoteSiteName : remoteSiteNames) {
            remoteSites.add(ServiceDependency.on((BinaryServiceDescriptor)RemoteSiteConfiguration.SERVICE_DESCRIPTOR, (String)stackName, (String)remoteSiteName));
        }
        return new ServiceDependency<RelayConfiguration>(){

            public void accept(RequirementServiceBuilder<?> builder) {
                protocol.accept(builder);
                for (ServiceDependency remoteSite : remoteSites) {
                    remoteSite.accept(builder);
                }
            }

            public RelayConfiguration get() {
                return new AbstractRelayConfiguration((ProtocolConfiguration)protocol.get()){

                    @Override
                    public RELAY2 createProtocol(ChannelFactoryConfiguration configuration) {
                        RELAY2 protocol = (RELAY2)super.createProtocol(configuration);
                        List<RemoteSiteConfiguration> remoteSites = this.getRemoteSites();
                        ArrayList<String> sites = new ArrayList<String>(remoteSites.size() + 1);
                        sites.add(siteName);
                        HashMap<String, 1> bridges = new HashMap<String, 1>();
                        for (final RemoteSiteConfiguration remoteSite : remoteSites) {
                            final String siteName = remoteSite.getName();
                            sites.add(siteName);
                            String clusterName = remoteSite.getClusterName();
                            RelayConfig.BridgeConfig bridge = new RelayConfig.BridgeConfig(clusterName){

                                public JChannel createChannel() throws Exception {
                                    JChannel channel = remoteSite.getChannelFactory().createChannel(siteName);
                                    channel.getProtocolStack().removeProtocol(FORK.class);
                                    return channel;
                                }
                            };
                            bridges.put(clusterName, bridge);
                        }
                        protocol.site(siteName);
                        for (String site : sites) {
                            RelayConfig.SiteConfig siteConfig = new RelayConfig.SiteConfig(site);
                            protocol.addSite(site, siteConfig);
                            if (!site.equals(siteName)) continue;
                            for (RelayConfig.BridgeConfig bridge : bridges.values()) {
                                siteConfig.addBridge(bridge);
                            }
                        }
                        return protocol;
                    }

                    public String getSiteName() {
                        return siteName;
                    }

                    public List<RemoteSiteConfiguration> getRemoteSites() {
                        return remoteSites.stream().map(Supplier::get).collect(Collectors.toUnmodifiableList());
                    }
                };
            }
        };
    }

    static enum Attribute implements AttributeDefinitionProvider
    {
        SITE("site", ModelType.STRING);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition get() {
            return this.definition;
        }
    }

    static abstract class AbstractRelayConfiguration
    extends ProtocolConfigurationResourceDefinitionRegistrar.ProtocolConfigurationDecorator<RELAY2>
    implements RelayConfiguration {
        AbstractRelayConfiguration(ProtocolConfiguration<RELAY2> configuration) {
            super(configuration);
        }
    }

    static enum Protocol implements ResourceRegistration
    {
        RELAY2("relay.RELAY2");

        private final PathElement path;

        private Protocol(String name) {
            this.path = StackResourceDefinitionRegistrar.Component.RELAY.pathElement(name);
        }

        public PathElement getPathElement() {
            return this.path;
        }
    }
}

