/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.api.query;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.api.query.ClosableIteratorWithCount;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.commons.api.query.impl.QueryPublisher;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Experimental;
import org.reactivestreams.Publisher;

public interface Query<T>
extends Iterable<T> {
    public String getQueryString();

    public List<T> list();

    @Experimental
    default public Publisher<T> publish(int maxBatchSize) {
        return new QueryPublisher(this, maxBatchSize);
    }

    public QueryResult<T> execute();

    @Experimental
    public CompletionStage<QueryResult<T>> executeAsync();

    public int executeStatement();

    @Experimental
    public CompletionStage<Integer> executeStatementAsync();

    public boolean hasProjections();

    public long getStartOffset();

    public Query<T> startOffset(long var1);

    public int getMaxResults();

    public Query<T> maxResults(int var1);

    public Integer hitCountAccuracy();

    public Query<T> hitCountAccuracy(int var1);

    public Map<String, Object> getParameters();

    public Query<T> setParameter(String var1, Object var2);

    public Query<T> setParameters(Map<String, Object> var1);

    @Override
    public CloseableIterator<T> iterator();

    default public <K> ClosableIteratorWithCount<EntityEntry<K, T>> entryIterator() {
        return this.entryIterator(false);
    }

    public <K> ClosableIteratorWithCount<EntityEntry<K, T>> entryIterator(boolean var1);

    public Query<T> timeout(long var1, TimeUnit var3);

    public Query<T> local(boolean var1);

    public Query<T> scoreRequired(boolean var1);
}

