/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.management.JMException;
import javax.management.MBeanServer;
import org.jboss.as.controller.ServiceNameFactory;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.ejb3.security.service.EJBViewMethodSecurityAttributesService;
import org.jboss.as.ejb3.subsystem.ApplicationSecurityDomainService;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.security.EJBMethodSecurityAttributesAdaptor;
import org.jboss.as.webservices.security.ElytronSecurityDomainContextImpl;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.ServiceContainerEndpointRegistry;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.ws.api.monitoring.RecordProcessor;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.ws.common.management.ManagedEndpoint;
import org.jboss.ws.common.monitoring.ManagedRecordProcessor;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointType;
import org.jboss.wsf.spi.management.EndpointMetricsFactory;
import org.jboss.wsf.spi.security.EJBMethodSecurityAttributeProvider;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;
import org.wildfly.security.auth.server.SecurityDomain;

public final class EndpointService
implements Service {
    private static final ServiceName SECURITY_DOMAIN_SERVICE = ServiceName.JBOSS.append(new String[]{"security", "security-domain"});
    private static final String ELYTRON_SECURITY_CAPABILITY = "org.wildfly.security.elytron";
    private static final String WEB_APPLICATION_SECURITY_DOMAIN = "org.wildfly.undertow.application-security-domain";
    private static final String EJB_APPLICATION_SECURITY_DOMAIN = "org.wildfly.ejb3.application-security-domain";
    private static final RuntimeCapability<Void> EJB_APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.ejb3.application-security-domain", (boolean)true, ApplicationSecurityDomainService.ApplicationSecurityDomain.class).build();
    private static final String SECURITY_DOMAIN_NAME = "securityDomainName";
    private static final String ELYTRON_SECURITY_DOMAIN = "elytronSecurityDomain";
    private final Endpoint endpoint;
    private final ServiceName name;
    private final ServiceName aliasName;
    private final Consumer<Endpoint> endpointConsumer;
    private final Supplier<AbstractServerConfig> serverConfigService;
    private final Supplier<ApplicationSecurityDomainService.ApplicationSecurityDomain> ejbApplicationSecurityDomain;
    private final Supplier<EJBViewMethodSecurityAttributesService> ejbMethodSecurityAttributeService;
    private final Supplier<SecurityDomain> elytronSecurityDomain;
    private static final String DEFAULT_SECURITY_NAME = "other";
    private static final String JAAS_CONTEXT_ROOT = "java:/jaas/";

    private EndpointService(Endpoint endpoint, ServiceName name, ServiceName aliasName, Consumer<Endpoint> endpointConsumer, Supplier<AbstractServerConfig> serverConfigService, Supplier<ApplicationSecurityDomainService.ApplicationSecurityDomain> ejbApplicationSecurityDomain, Supplier<EJBViewMethodSecurityAttributesService> ejbMethodSecurityAttributeService, Supplier<SecurityDomain> elytronSecurityDomain) {
        this.endpoint = endpoint;
        this.name = name;
        this.aliasName = aliasName;
        this.endpointConsumer = endpointConsumer;
        this.serverConfigService = serverConfigService;
        this.ejbApplicationSecurityDomain = ejbApplicationSecurityDomain;
        this.ejbMethodSecurityAttributeService = ejbMethodSecurityAttributeService;
        this.elytronSecurityDomain = elytronSecurityDomain;
    }

    public static ServiceName getServiceName(DeploymentUnit unit, String endpointName) {
        if (unit.getParent() != null) {
            return WSServices.ENDPOINT_SERVICE.append(new String[]{unit.getParent().getName()}).append(new String[]{unit.getName()}).append(new String[]{endpointName});
        }
        return WSServices.ENDPOINT_SERVICE.append(new String[]{unit.getName()}).append(new String[]{endpointName});
    }

    public void start(StartContext context) {
        WSLogger.ROOT_LOGGER.starting(this.name);
        if (this.endpoint.getProperty(ELYTRON_SECURITY_DOMAIN) != null && Boolean.parseBoolean(this.endpoint.getProperty(ELYTRON_SECURITY_DOMAIN).toString())) {
            if (EndpointType.JAXWS_EJB3.equals((Object)this.endpoint.getType())) {
                this.endpoint.setSecurityDomainContext((SecurityDomainContext)new ElytronSecurityDomainContextImpl(this.ejbApplicationSecurityDomain.get().getSecurityDomain()));
            } else {
                this.endpoint.setSecurityDomainContext((SecurityDomainContext)new ElytronSecurityDomainContextImpl(this.elytronSecurityDomain.get()));
            }
        }
        if (EndpointType.JAXWS_EJB3.equals((Object)this.endpoint.getType())) {
            EJBViewMethodSecurityAttributesService ejbMethodSecurityAttributeService = this.ejbMethodSecurityAttributeService.get();
            this.endpoint.addAttachment(EJBMethodSecurityAttributeProvider.class, (Object)new EJBMethodSecurityAttributesAdaptor(ejbMethodSecurityAttributeService));
        }
        List processors = this.endpoint.getRecordProcessors();
        for (RecordProcessor processor : processors) {
            this.registerRecordProcessor(processor, this.endpoint);
        }
        EndpointMetricsFactory endpointMetricsFactory = (EndpointMetricsFactory)SPIProvider.getInstance().getSPI(EndpointMetricsFactory.class);
        this.endpoint.setEndpointMetrics(endpointMetricsFactory.newEndpointMetrics());
        this.registerEndpoint(this.endpoint);
        this.endpoint.getLifecycleHandler().start(this.endpoint);
        ServiceContainerEndpointRegistry.register(this.aliasName, this.endpoint);
        this.endpointConsumer.accept(this.endpoint);
    }

    public void stop(StopContext context) {
        WSLogger.ROOT_LOGGER.stopping(this.name);
        ServiceContainerEndpointRegistry.unregister(this.aliasName, this.endpoint);
        this.endpoint.getLifecycleHandler().stop(this.endpoint);
        this.endpoint.setSecurityDomainContext(null);
        this.unregisterEndpoint(this.endpoint);
        List processors = this.endpoint.getRecordProcessors();
        for (RecordProcessor processor : processors) {
            this.unregisterRecordProcessor(processor, this.endpoint);
        }
    }

    private void registerEndpoint(Endpoint endpoint) {
        MBeanServer mbeanServer = this.serverConfigService.get().getMbeanServer();
        if (mbeanServer != null) {
            try {
                ManagedEndpoint jmxEndpoint = new ManagedEndpoint(endpoint, mbeanServer);
                mbeanServer.registerMBean(jmxEndpoint, endpoint.getName());
            }
            catch (JMException ex) {
                WSLogger.ROOT_LOGGER.trace("Cannot register endpoint in JMX server", ex);
                WSLogger.ROOT_LOGGER.cannotRegisterEndpoint(endpoint.getShortName());
            }
        } else {
            WSLogger.ROOT_LOGGER.mBeanServerNotAvailable(endpoint.getShortName());
        }
    }

    private void unregisterEndpoint(Endpoint endpoint) {
        MBeanServer mbeanServer = this.serverConfigService.get().getMbeanServer();
        if (mbeanServer != null) {
            try {
                mbeanServer.unregisterMBean(endpoint.getName());
            }
            catch (JMException ex) {
                WSLogger.ROOT_LOGGER.trace("Cannot unregister endpoint from JMX server", ex);
                WSLogger.ROOT_LOGGER.cannotUnregisterEndpoint(endpoint.getShortName());
            }
        } else {
            WSLogger.ROOT_LOGGER.mBeanServerNotAvailable(endpoint.getShortName());
        }
    }

    private void registerRecordProcessor(RecordProcessor processor, Endpoint ep) {
        MBeanServer mbeanServer = this.serverConfigService.get().getMbeanServer();
        if (mbeanServer != null) {
            try {
                mbeanServer.registerMBean(processor, ObjectNameFactory.create((String)(String.valueOf(ep.getName()) + ",recordProcessor=" + processor.getName())));
            }
            catch (JMException ex) {
                WSLogger.ROOT_LOGGER.trace("Cannot register endpoint in JMX server, trying with the default ManagedRecordProcessor", ex);
                try {
                    mbeanServer.registerMBean(new ManagedRecordProcessor(processor), ObjectNameFactory.create((String)(String.valueOf(ep.getName()) + ",recordProcessor=" + processor.getName())));
                }
                catch (JMException e) {
                    WSLogger.ROOT_LOGGER.cannotRegisterRecordProcessor();
                }
            }
        } else {
            WSLogger.ROOT_LOGGER.mBeanServerNotAvailable(processor);
        }
    }

    private void unregisterRecordProcessor(RecordProcessor processor, Endpoint ep) {
        MBeanServer mbeanServer = this.serverConfigService.get().getMbeanServer();
        if (mbeanServer != null) {
            try {
                mbeanServer.unregisterMBean(ObjectNameFactory.create((String)(String.valueOf(ep.getName()) + ",recordProcessor=" + processor.getName())));
            }
            catch (JMException e) {
                WSLogger.ROOT_LOGGER.cannotUnregisterRecordProcessor();
            }
        } else {
            WSLogger.ROOT_LOGGER.mBeanServerNotAvailable(processor);
        }
    }

    public static void install(ServiceTarget serviceTarget, Endpoint endpoint, DeploymentUnit unit) {
        ServiceName serviceName = EndpointService.getServiceName(unit, endpoint.getShortName());
        String propContext = endpoint.getName().getKeyProperty("context");
        String propEndpoint = endpoint.getName().getKeyProperty("endpoint");
        StringBuilder context = new StringBuilder("context").append("=").append(propContext);
        ServiceBuilder builder = serviceTarget.addService(serviceName);
        Supplier ejbApplicationSecurityDomain = null;
        Supplier ejbMethodSecurityAttributeService = null;
        Supplier elytronSecurityDomain = null;
        ServiceName alias = WSServices.ENDPOINT_SERVICE.append(new String[]{context.toString()}).append(new String[]{propEndpoint});
        Consumer endpointConsumer = builder.provides(new ServiceName[]{serviceName, alias});
        String domainName = EndpointService.getDeploymentSecurityDomainName(endpoint, unit);
        endpoint.setProperty(SECURITY_DOMAIN_NAME, (Object)domainName);
        if (EndpointService.isElytronSecurityDomain(unit, endpoint, domainName)) {
            if (EndpointType.JAXWS_EJB3.equals((Object)endpoint.getType())) {
                ServiceName ejbSecurityDomainServiceName = EJB_APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.getCapabilityServiceName(domainName, ApplicationSecurityDomainService.ApplicationSecurityDomain.class);
                ejbApplicationSecurityDomain = builder.requires(ejbSecurityDomainServiceName);
            } else {
                CapabilityServiceSupport capabilityServiceSupport = (CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
                if (capabilityServiceSupport != null) {
                    ServiceName securityDomainName = capabilityServiceSupport.getCapabilityServiceName(WEB_APPLICATION_SECURITY_DOMAIN, new String[]{domainName}).append(new String[]{"security-domain"});
                    elytronSecurityDomain = builder.requires(securityDomainName);
                } else {
                    ServiceName publishEndpointSecurityDomainName = ServiceNameFactory.parseServiceName((String)WEB_APPLICATION_SECURITY_DOMAIN).append(new String[]{domainName}).append(new String[]{"security-domain"});
                    elytronSecurityDomain = builder.requires(publishEndpointSecurityDomainName);
                }
            }
            endpoint.setProperty(ELYTRON_SECURITY_DOMAIN, (Object)true);
        } else if (EndpointService.isLegacySecurityDomain(unit, endpoint, domainName)) {
            throw WSLogger.ROOT_LOGGER.legacySecurityUnsupported();
        }
        Supplier serverConfigService = builder.requires(WSServices.CONFIG_SERVICE);
        if (EndpointType.JAXWS_EJB3.equals((Object)endpoint.getType())) {
            ejbMethodSecurityAttributeService = builder.requires(EndpointService.getEJBViewMethodSecurityAttributesServiceName(unit, endpoint));
        }
        builder.setInstance((Service)new EndpointService(endpoint, serviceName, alias, endpointConsumer, serverConfigService, ejbApplicationSecurityDomain, ejbMethodSecurityAttributeService, elytronSecurityDomain));
        builder.install();
        unit.addToAttachmentList(Attachments.WEB_DEPENDENCIES, (Object)serviceName);
    }

    public static void uninstall(Endpoint endpoint, DeploymentUnit unit) {
        ServiceName serviceName = EndpointService.getServiceName(unit, endpoint.getShortName());
        ServiceController endpointService = EndpointService.currentServiceContainer().getService(serviceName);
        if (endpointService != null) {
            endpointService.setMode(ServiceController.Mode.REMOVE);
        }
    }

    private static String getDeploymentSecurityDomainName(Endpoint ep, DeploymentUnit unit) {
        String metaDataSecurityDomain;
        JBossWebMetaData metadata = (JBossWebMetaData)ep.getService().getDeployment().getAttachment(JBossWebMetaData.class);
        String string = metaDataSecurityDomain = metadata != null ? metadata.getSecurityDomain() : null;
        metaDataSecurityDomain = metaDataSecurityDomain == null ? (unit.hasAttachment(UndertowAttachments.DEFAULT_SECURITY_DOMAIN) ? (String)unit.getAttachment(UndertowAttachments.DEFAULT_SECURITY_DOMAIN) : DEFAULT_SECURITY_NAME) : EndpointService.unprefixSecurityDomain(metaDataSecurityDomain.trim());
        return metaDataSecurityDomain;
    }

    private static ServiceName getEJBViewMethodSecurityAttributesServiceName(DeploymentUnit unit, Endpoint endpoint) {
        for (EJBEndpoint ep : ASHelper.getJaxwsEjbs(unit)) {
            if (!ep.getClassName().equals(endpoint.getTargetBeanName())) continue;
            return ep.getEJBViewMethodSecurityAttributesService();
        }
        return null;
    }

    static List<ServiceName> getServiceNamesFromDeploymentUnit(DeploymentUnit unit) {
        ArrayList<ServiceName> endpointServiceNames = new ArrayList<ServiceName>();
        Deployment deployment = (Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
        for (Endpoint ep : deployment.getService().getEndpoints()) {
            endpointServiceNames.add(EndpointService.getServiceName(unit, ep.getShortName()));
        }
        return endpointServiceNames;
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    private static boolean isElytronSecurityDomain(DeploymentUnit unit, Endpoint endpoint, String domainName) {
        CapabilityServiceSupport capabilitySupport = (CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        if (capabilitySupport != null && !capabilitySupport.hasCapability(ELYTRON_SECURITY_CAPABILITY)) {
            return false;
        }
        ServiceName serviceName = EndpointType.JAXWS_EJB3.equals((Object)endpoint.getType()) ? EJB_APPLICATION_SECURITY_DOMAIN_RUNTIME_CAPABILITY.getCapabilityServiceName(domainName, ApplicationSecurityDomainService.ApplicationSecurityDomain.class) : ServiceNameFactory.parseServiceName((String)WEB_APPLICATION_SECURITY_DOMAIN).append(new String[]{domainName}).append(new String[]{"security-domain"});
        return EndpointService.currentServiceContainer().getService(serviceName) != null;
    }

    private static boolean isLegacySecurityDomain(DeploymentUnit unit, Endpoint endpoint, String domainName) {
        CapabilityServiceSupport capabilitySupport = (CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        ServiceName serviceName = SECURITY_DOMAIN_SERVICE.append(new String[]{domainName});
        return EndpointService.currentServiceContainer().getService(serviceName) != null;
    }

    public static String unprefixSecurityDomain(String securityDomain) {
        String result = null;
        if (securityDomain != null) {
            result = securityDomain.startsWith("java:jboss/jaas/") ? securityDomain.substring("java:jboss/jaas/".length()) : (securityDomain.startsWith("java:jboss/jbsx/") ? securityDomain.substring("java:jboss/jbsx/".length()) : (securityDomain.startsWith(JAAS_CONTEXT_ROOT) ? securityDomain.substring(JAAS_CONTEXT_ROOT.length()) : securityDomain));
        }
        return result;
    }
}

