/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

public final class XTSClientIntegrationService
implements Service {
    private final Supplier<ServerConfig> serverConfig;
    private final Supplier<UnifiedHandlerChainMetaData> postHandlerChains;

    private XTSClientIntegrationService(Supplier<ServerConfig> serverConfig, Supplier<UnifiedHandlerChainMetaData> postHandlerChains) {
        this.serverConfig = serverConfig;
        this.postHandlerChains = postHandlerChains;
    }

    public void start(StartContext context) {
        ArrayList<UnifiedHandlerChainMetaData> postHandlerChainsList = new ArrayList<UnifiedHandlerChainMetaData>();
        postHandlerChainsList.add(this.postHandlerChains.get());
        ClientConfig wrapper = new ClientConfig(null, null, postHandlerChainsList, null, null);
        ((ServerConfigImpl)this.serverConfig.get()).setClientConfigWrapper(wrapper, true);
    }

    public void stop(StopContext context) {
        ((ServerConfigImpl)this.serverConfig.get()).setClientConfigWrapper(null, false);
    }

    public static ServiceController<?> install(ServiceTarget serviceTarget) {
        ServiceBuilder builder = serviceTarget.addService(WSServices.XTS_CLIENT_INTEGRATION_SERVICE);
        Supplier serverConfig = builder.requires(WSServices.CONFIG_SERVICE);
        Supplier postHandlerChains = builder.requires(ServiceName.JBOSS.append(new String[]{"xts"}).append(new String[]{"handlers"}));
        builder.setInstance((Service)new XTSClientIntegrationService(serverConfig, postHandlerChains));
        return builder.setInitialMode(ServiceController.Mode.PASSIVE).install();
    }
}

