/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.management;

import com.arjuna.ats.arjuna.common.CoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreBrowser;
import com.arjuna.ats.arjuna.tools.osb.util.JMXServer;
import com.arjuna.ats.internal.arjuna.objectstore.hornetq.HornetqJournalEnvironmentBean;
import com.arjuna.ats.internal.arjuna.objectstore.hornetq.HornetqObjectStoreAdaptor;
import com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import io.narayana.lra.coordinator.domain.model.FailedLongRunningAction;
import io.narayana.lra.coordinator.domain.model.LongRunningAction;
import io.narayana.lra.coordinator.internal.Implementations;
import io.narayana.lra.coordinator.internal.LRARecoveryModule;
import io.narayana.lra.coordinator.tools.osb.mbean.LRAActionBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class BrowserCommand {
    private static final String SYNTAX = "syntax: [-s <store location>] | [-f <command file>]]";
    private static String currentStoreDir;
    private static ObjStoreBrowser osb;
    private static String currentType;
    private static List<String> recordTypes;
    private static InputStream cmdSource;
    private static RecoveryManagerImple recoveryManager;
    private static boolean isHQStore;
    private static String[][] LRA_OSB_TYPES;
    CommandName name;
    boolean verbose;
    private static final BrowserCommand[] commands;

    static BrowserCommand getCommand(CommandName name) {
        return BrowserCommand.getCommand(name.name());
    }

    static BrowserCommand getCommand(String name) {
        name = name.toUpperCase();
        for (BrowserCommand command : commands) {
            if (!command.name.name().startsWith(name)) continue;
            return command;
        }
        return BrowserCommand.getCommand(CommandName.HELP);
    }

    private static void parseArgs(String[] args) throws FileNotFoundException {
        String validOpts = "fsh";
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            if (i + 1 >= args.length || args[i].length() != 2 || validOpts.indexOf(args[i].charAt(1)) == -1) {
                throw new IllegalArgumentException(SYNTAX);
            }
            switch (args[i++].charAt(1)) {
                case 'f': {
                    File f = BrowserCommand.validateFile(args[i], false);
                    Scanner s = new Scanner(new FileInputStream(f));
                    while (s.hasNext()) {
                        String ln = s.nextLine();
                        sb.append(ln.trim()).append(System.lineSeparator());
                    }
                    continue block5;
                }
                case 's': {
                    currentStoreDir = args[i];
                    continue block5;
                }
                case 'h': {
                    isHQStore = Boolean.parseBoolean(args[i]);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException(SYNTAX);
                }
            }
        }
        if (currentStoreDir == null) {
            currentStoreDir = ((ObjectStoreEnvironmentBean)BeanPopulator.getDefaultInstance(ObjectStoreEnvironmentBean.class)).getObjectStoreDir();
        } else {
            ((ObjectStoreEnvironmentBean)BeanPopulator.getDefaultInstance(ObjectStoreEnvironmentBean.class)).setObjectStoreDir(currentStoreDir);
        }
        BrowserCommand.validateFile(currentStoreDir, true);
        if (cmdSource == null) {
            cmdSource = sb.isEmpty() ? System.in : new ByteArrayInputStream(sb.toString().getBytes());
        }
    }

    private static File validateFile(String name, boolean isDir) {
        File f = new File(name);
        if (!f.exists() || !(isDir ^ f.isFile())) {
            throw new IllegalArgumentException("File " + name + " does not exist");
        }
        return f;
    }

    private static boolean setCurrentStoreDir(String val) {
        if (val.trim().toUpperCase().startsWith(CommandName.STORE_DIR.name())) {
            String[] aa = val.split("\\s+");
            if (aa.length < 2) {
                throw new IllegalArgumentException("Invalid syntax for command " + CommandName.STORE_DIR.name());
            }
            currentStoreDir = aa[1];
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        BrowserCommand.parseArgs(args);
        BrowserCommand.getCommand(CommandName.START).execute(new PrintStream(System.out, true), null);
    }

    public static String run(String[] args) throws Exception {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            PrintStream printStream = new PrintStream(outputStream);
            try {
                BrowserCommand.parseArgs(args);
                BrowserCommand.getCommand(CommandName.START).execute(printStream, null);
                String string = outputStream.toString();
                printStream.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    printStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private BrowserCommand(CommandName name) {
        this.name = name;
    }

    abstract void execute(PrintStream var1, List<String> var2) throws Exception;

    protected void help(PrintStream printStream) {
        if (this.name.cmdHelp != null) {
            printStream.printf("%s - %s%n", this.name.name().toLowerCase(), this.name.cmdHelp);
        }
    }

    boolean cancel() {
        return true;
    }

    private static void setupStore(String storeDir) throws Exception {
        recoveryPropertyManager.getRecoveryEnvironmentBean().setRecoveryBackoffPeriod(1);
        Implementations.install();
        BrowserCommand.setupStore(storeDir, isHQStore);
        recoveryManager = new RecoveryManagerImple(false);
        recoveryManager.addModule((RecoveryModule)new LRARecoveryModule());
        osb = ObjStoreBrowser.getInstance();
        for (String[] typeAndBean : LRA_OSB_TYPES) {
            osb.addType(typeAndBean[0], typeAndBean[1], typeAndBean[2]);
        }
        osb.start();
    }

    private static void setupStore(String storeDir, boolean hqstore) throws Exception {
        String storePath = new File(storeDir).getCanonicalPath();
        ObjectStoreEnvironmentBean commsObjStoreCommsEnvBean = (ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"communicationStore");
        ObjectStoreEnvironmentBean defObjStoreCommsEnvBean = (ObjectStoreEnvironmentBean)BeanPopulator.getDefaultInstance(ObjectStoreEnvironmentBean.class);
        if (hqstore) {
            File hornetqStoreDir = new File(storeDir);
            String storeClassName = HornetqObjectStoreAdaptor.class.getName();
            ((HornetqJournalEnvironmentBean)BeanPopulator.getDefaultInstance(HornetqJournalEnvironmentBean.class)).setStoreDir(hornetqStoreDir.getCanonicalPath());
            defObjStoreCommsEnvBean.setObjectStoreType(storeClassName);
            commsObjStoreCommsEnvBean.setObjectStoreDir(storeDir);
            defObjStoreCommsEnvBean.setObjectStoreType(storeClassName);
            commsObjStoreCommsEnvBean.setObjectStoreType(storeClassName);
        } else {
            defObjStoreCommsEnvBean.setObjectStoreDir(storePath);
            commsObjStoreCommsEnvBean.setObjectStoreDir(storePath);
        }
        ((CoreEnvironmentBean)BeanPopulator.getDefaultInstance(CoreEnvironmentBean.class)).setNodeIdentifier("no-recovery");
        currentStoreDir = storeDir;
    }

    private static void restartStore(String storeDir) throws Exception {
        StoreManager.shutdown();
        if (osb != null) {
            osb.stop();
        }
        try {
            RecoveryManager.manager().terminate(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BrowserCommand.setupStore(storeDir);
    }

    static {
        currentType = "";
        recordTypes = new ArrayList<String>();
        LRA_OSB_TYPES = new String[][]{{LongRunningAction.getType().substring(1), LongRunningAction.class.getName(), LRAActionBean.class.getName()}, {FailedLongRunningAction.getType().substring(1), FailedLongRunningAction.class.getName(), LRAActionBean.class.getName()}};
        commands = new BrowserCommand[]{new BrowserCommand(CommandName.HELP){

            @Override
            void execute(PrintStream printStream, List<String> args) {
                for (BrowserCommand command : commands) {
                    command.help(printStream);
                }
            }
        }, new BrowserCommand(CommandName.START){
            boolean finished;

            @Override
            void execute(PrintStream printStream, List<String> args) throws Exception {
                BrowserCommand.setupStore(currentStoreDir);
                Scanner scanner = new Scanner(cmdSource);
                2.getCommand(CommandName.PROBE).execute(printStream, null);
                2.getCommand(CommandName.TYPES).execute(printStream, null);
                while (!this.finished) {
                    this.processCommand(printStream, scanner);
                }
                scanner.close();
                StoreManager.shutdown();
                if (osb != null) {
                    osb.stop();
                }
                try {
                    RecoveryManager.manager().terminate(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            @Override
            boolean cancel() {
                this.finished = true;
                try {
                    cmdSource.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }

            private void processCommand(PrintStream printStream, Scanner scanner) {
                block2: {
                    printStream.printf("%s> ", currentType);
                    ArrayList<String> args = new ArrayList<String>(Arrays.asList(scanner.nextLine().split("\\s+")));
                    BrowserCommand command = args.size() == 0 ? 2.getCommand(CommandName.HELP) : 2.getCommand((String)args.remove(0));
                    try {
                        command.execute(printStream, args);
                    }
                    catch (Exception e) {
                        printStream.printf("%s%n", e.getMessage());
                        if (!this.verbose) break block2;
                        e.printStackTrace(printStream);
                    }
                }
            }
        }, new BrowserCommand(CommandName.QUIT){

            @Override
            void execute(PrintStream printStream, List<String> args) throws Exception {
                3.getCommand(CommandName.START).cancel();
                StoreManager.shutdown();
            }
        }, new BrowserCommand(CommandName.STORE_DIR){

            @Override
            void execute(PrintStream printStream, List<String> args) throws Exception {
                if (args.size() == 0) {
                    printStream.print(currentStoreDir);
                } else {
                    printStream.printf("not supported - please restart and use the \"-s\" option (%s)", BrowserCommand.SYNTAX);
                }
            }
        }, new BrowserCommand(CommandName.PROBE){

            @Override
            void execute(PrintStream printStream, List<String> args) throws Exception {
                osb.probe();
            }
        }, new BrowserCommand(CommandName.EXCEPTION_TRACE){

            @Override
            void execute(PrintStream printStream, List<String> args) throws Exception {
                BrowserCommand startCmd = 6.getCommand(CommandName.START);
                if (args.size() == 1) {
                    startCmd.verbose = Boolean.parseBoolean(args.get(0));
                }
                printStream.printf("exceptionTrace is %b", startCmd.verbose);
            }
        }, new BrowserCommand(CommandName.TYPES){

            @Override
            void execute(PrintStream printStream, List<String> args) throws Exception {
                recordTypes.clear();
                InputObjectState types = new InputObjectState();
                if (StoreManager.getRecoveryStore().allTypes(types)) {
                    String typeName;
                    do {
                        try {
                            typeName = types.unpackString();
                            recordTypes.add(typeName);
                            printStream.printf("%s%n", typeName);
                        }
                        catch (IOException e1) {
                            typeName = "";
                        }
                    } while (!typeName.isEmpty());
                }
            }
        }, new BrowserCommand(CommandName.SELECT){

            @Override
            void execute(PrintStream printStream, List<String> args) throws Exception {
                if (args.size() < 1) {
                    currentType = "";
                } else if (!recordTypes.contains(args.get(0))) {
                    printStream.printf("%s is not a valid transaction type%n", args.get(0));
                } else {
                    currentType = args.get(0);
                }
            }
        }, new BrowserCommand(CommandName.LS){

            @Override
            void execute(PrintStream printStream, List<String> args) throws Exception {
                if (!args.isEmpty()) {
                    9.getCommand(CommandName.SELECT).execute(printStream, args);
                }
                if (currentType.isEmpty()) {
                    for (String type : recordTypes) {
                        this.listMBeans(printStream, type);
                    }
                } else {
                    this.listMBeans(printStream, currentType);
                }
            }

            void listMBeans(PrintStream printStream, String itype) throws MalformedObjectNameException, ReflectionException, InstanceNotFoundException, IntrospectionException {
                MBeanServer mbs = JMXServer.getAgent().getServer();
                String osMBeanName = "jboss.jta:type=ObjectStore,itype=" + itype;
                Set<ObjectInstance> transactions = mbs.queryMBeans(new ObjectName(osMBeanName + ",*"), null);
                printStream.printf("Transactions of type %s%n", osMBeanName);
                for (ObjectInstance oi : transactions) {
                    String transactionId = oi.getObjectName().getCanonicalName();
                    if (transactionId.contains("puid") || !transactionId.contains("itype")) continue;
                    printStream.printf("Transaction: %s%n", oi.getObjectName());
                    String participantQuery = transactionId + ",puid=*";
                    Set<ObjectInstance> participants = mbs.queryMBeans(new ObjectName(participantQuery), null);
                    this.printAtrributes(printStream, "\t", mbs, oi);
                    printStream.printf("\tParticipants:%n", new Object[0]);
                    for (ObjectInstance poi : participants) {
                        printStream.printf("\t\tParticipant: %s%n", poi);
                        this.printAtrributes(printStream, "\t\t\t", mbs, poi);
                    }
                }
            }

            void printAtrributes(PrintStream printStream, String printPrefix, MBeanServer mbs, ObjectInstance oi) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
                MBeanInfo info = mbs.getMBeanInfo(oi.getObjectName());
                MBeanAttributeInfo[] attributeArray = info.getAttributes();
                int i = 0;
                String[] attributeNames = new String[attributeArray.length];
                for (MBeanAttributeInfo ai : attributeArray) {
                    attributeNames[i++] = ai.getName();
                }
                AttributeList attributes = mbs.getAttributes(oi.getObjectName(), attributeNames);
                for (Attribute attribute : attributes.asList()) {
                    Object value = attribute.getValue();
                    String v = value == null ? "null" : value.toString();
                    printStream.printf("%s%s=%s%n", printPrefix, attribute.getName(), v);
                }
            }
        }};
    }

    private static enum CommandName {
        HELP("show command options and syntax"),
        SELECT("<type> - start browsing a particular transaction type"),
        STORE_DIR("get/set the location of the object store (set fails)"),
        START(null),
        TYPES("list record types"),
        PROBE("refresh the view of the object store"),
        LS("[type] - list transactions of type type. Use the select command to set the default type"),
        QUIT("exit the browser"),
        EXCEPTION_TRACE("true | false - show full exception traces");

        final String cmdHelp;

        private CommandName(String cmdHelp) {
            this.cmdHelp = cmdHelp;
        }
    }
}

