/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.scheduler;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.wildfly.clustering.cache.Key;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.infinispan.scheduler.CacheEntryScheduler;

public class CacheEntriesTask<K, V>
implements Consumer<CacheStreamFilter<Map.Entry<K, V>>> {
    private final Cache<K, V> cache;
    private final Predicate<Map.Entry<? super K, ? super V>> filter;
    private final Consumer<Map.Entry<K, V>> task;

    public static <I, K extends Key<I>, V, M> CacheEntriesTask<K, V> schedule(Cache<K, V> cache, Predicate<Map.Entry<? super K, ? super V>> filter, CacheEntryScheduler<I, K, V, M> scheduler) {
        return new CacheEntriesTask<K, V>(cache, filter, scheduler::schedule);
    }

    public static <I, K extends Key<I>, V, M> CacheEntriesTask<K, V> cancel(Cache<K, V> cache, Predicate<Map.Entry<? super K, ? super V>> filter, CacheEntryScheduler<I, K, V, M> scheduler) {
        Consumer cancel = arg_0 -> scheduler.cancel(arg_0);
        org.wildfly.clustering.function.Function key = Map.Entry::getKey;
        return new CacheEntriesTask<K, V>(cache, filter, cancel.compose((Function)key.andThen(Key::getId)));
    }

    public CacheEntriesTask(Cache<K, V> cache, Predicate<Map.Entry<? super K, ? super V>> filter, Consumer<Map.Entry<K, V>> task) {
        this.cache = cache;
        this.filter = filter;
        this.task = task;
    }

    public void accept(CacheStreamFilter<Map.Entry<K, V>> filter) {
        try (CacheStream stream = ((CacheStream)filter.apply((Object)this.cache.entrySet().stream())).filter(this.filter);){
            Iterator entries = stream.iterator();
            while (entries.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                this.task.accept((Object)((Map.Entry)entries.next()));
            }
        }
    }
}

