/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.ws.rs.WebApplicationException;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.cdi.Utils;
import org.jboss.resteasy.cdi.i18n.LogMessages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;

public class CdiPropertyInjector
implements PropertyInjector {
    private static final Class<?> WELD_PROXY_CLASS;
    private static final CallSite META_DATA_GETTER;
    private static final CallSite CONTEXTUAL_INSTANCE_GETTER;
    private final PropertyInjector delegate;
    private final Class<?> clazz;
    private boolean injectorEnabled = true;

    public CdiPropertyInjector(PropertyInjector delegate, Class<?> clazz, Map<Class<?>, Type> sessionBeanInterface, BeanManager manager) {
        this.delegate = delegate;
        this.clazz = clazz;
        if (sessionBeanInterface.containsKey(clazz)) {
            this.injectorEnabled = false;
        }
        if (!manager.getBeans(clazz, new Annotation[0]).isEmpty() && Utils.isJaxrsComponent(clazz)) {
            this.injectorEnabled = false;
        }
    }

    public CompletionStage<Void> inject(Object target, boolean unwrapAsync) {
        if (this.injectorEnabled) {
            return this.delegate.inject(target, unwrapAsync);
        }
        return null;
    }

    public CompletionStage<Void> inject(HttpRequest request, HttpResponse response, Object target, boolean unwrapAsync) throws Failure, WebApplicationException, ApplicationException {
        if (this.injectorEnabled) {
            return this.delegate.inject(request, response, CdiPropertyInjector.unwrapIfRequired(target), unwrapAsync);
        }
        return null;
    }

    public String toString() {
        return "CdiPropertyInjector (enabled: " + this.injectorEnabled + ") for " + String.valueOf(this.clazz);
    }

    private static Object unwrapIfRequired(Object target) {
        try {
            if (WELD_PROXY_CLASS != null && WELD_PROXY_CLASS.isInstance(target)) {
                Object metaData = META_DATA_GETTER.dynamicInvoker().invoke(target);
                return CONTEXTUAL_INSTANCE_GETTER.dynamicInvoker().invoke(metaData);
            }
        }
        catch (Throwable e) {
            LogMessages.LOGGER.debugf(e, "Failed to handle unwrapping of %s", target);
        }
        return target;
    }

    static {
        Class<?> weldProxyClass = null;
        MethodHandle metaDataGetter = null;
        MethodHandle contextualInstanceGetter = null;
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            weldProxyClass = Class.forName("org.jboss.weld.proxy.WeldClientProxy");
            Class<?> metaData = Class.forName("org.jboss.weld.proxy.WeldClientProxy$Metadata");
            metaDataGetter = lookup.findVirtual(weldProxyClass, "getMetadata", MethodType.methodType(metaData));
            contextualInstanceGetter = lookup.findVirtual(metaData, "getContextualInstance", MethodType.methodType(Object.class));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        if (weldProxyClass == null || metaDataGetter == null || contextualInstanceGetter == null) {
            WELD_PROXY_CLASS = null;
            META_DATA_GETTER = null;
            CONTEXTUAL_INSTANCE_GETTER = null;
        } else {
            WELD_PROXY_CLASS = weldProxyClass;
            META_DATA_GETTER = new ConstantCallSite(metaDataGetter);
            CONTEXTUAL_INSTANCE_GETTER = new ConstantCallSite(contextualInstanceGetter);
        }
    }
}

