/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.logging;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;

@MessageLogger(projectCode="WFLYCLINF", length=4)
public interface InfinispanLogger
extends BasicLogger {
    public static final String ROOT_LOGGER_CATEGORY = "org.jboss.as.clustering.infinispan";
    public static final InfinispanLogger ROOT_LOGGER = (InfinispanLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), InfinispanLogger.class, (String)"org.jboss.as.clustering.infinispan");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating Infinispan subsystem.")
    public void activatingSubsystem();

    default public void started(BinaryServiceConfiguration configuration) {
        this.cacheStarted(configuration.getChildName(), configuration.getParentName());
    }

    default public void stopped(BinaryServiceConfiguration configuration) {
        this.cacheStopped(configuration.getChildName(), configuration.getParentName());
    }

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Started %s cache from %s container")
    public void cacheStarted(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Stopped %s cache from %s container")
    public void cacheStopped(String var1, String var2);

    @Message(id=10, value="%s is not a valid cache store")
    public IllegalArgumentException invalidCacheStore(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=29, value="Started remote cache container '%s'.")
    public void remoteCacheContainerStarted(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=30, value="Stopped remote cache container '%s'.")
    public void remoteCacheContainerStopped(String var1);

    @Message(id=31, value="Specified HotRod protocol version %s does not support creating caches automatically. Cache named '%s' must be already created on the Infinispan Server!")
    public HotRodClientException remoteCacheMustBeDefined(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=33, value="Attribute '%s' is configured to use a deprecated value: %s; use one of the following values instead: %s")
    public void marshallerEnumValueDeprecated(String var1, Object var2, Set<?> var3);
}

