/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.jboss.as.clustering.controller.EnumAttributeDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryServiceDescriptorFactory;
import org.jboss.as.clustering.infinispan.subsystem.ConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.MemoryResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.MemorySizeUnit;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.BinaryCapabilityNameResolver;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public class MemoryResourceDefinitionRegistrar
extends ConfigurationResourceDefinitionRegistrar<MemoryConfiguration, MemoryConfigurationBuilder> {
    static final BinaryServiceDescriptor<MemoryConfiguration> SERVICE_DESCRIPTOR = BinaryServiceDescriptorFactory.createServiceDescriptor(List.of(MemoryResourceRegistration.WILDCARD), MemoryConfiguration.class);
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)BinaryCapabilityNameResolver.GRANDPARENT_PARENT).setAllowMultipleRegistrations(true).build();
    static final AttributeDefinition SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("size", ModelType.LONG).setAllowExpression(true)).setRequired(false)).setValidator(LongRangeValidator.POSITIVE)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final EnumAttributeDefinition<MemorySizeUnit> SIZE_UNIT = new EnumAttributeDefinition.Builder("size-unit", (Enum)MemorySizeUnit.ENTRIES).build();
    private final StorageType storageType;
    private final EnumAttributeDefinition<MemorySizeUnit> sizeUnitAttribute;

    MemoryResourceDefinitionRegistrar(Configurator configurator) {
        super(configurator);
        this.storageType = configurator.getStorageType();
        this.sizeUnitAttribute = configurator.getSizeUnitAttribute();
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(SIZE, this.sizeUnitAttribute));
    }

    public ServiceDependency<MemoryConfigurationBuilder> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final StorageType storageType = this.storageType;
        final long size = SIZE.resolveModelAttribute(context, model).asLong(-1L);
        final MemorySizeUnit unit = (MemorySizeUnit)this.sizeUnitAttribute.resolve(context, model);
        final EvictionStrategy strategy = size > 0L ? EvictionStrategy.REMOVE : EvictionStrategy.MANUAL;
        return ServiceDependency.from((Supplier)new Supplier<MemoryConfigurationBuilder>(){

            @Override
            public MemoryConfigurationBuilder get() {
                MemoryConfigurationBuilder builder = new ConfigurationBuilder().memory().storage(storageType).whenFull(strategy);
                if (strategy.isEnabled()) {
                    if (unit == MemorySizeUnit.ENTRIES) {
                        builder.maxCount(size);
                    } else {
                        builder.maxSize(Long.toString(unit.applyAsLong(size)));
                    }
                }
                return builder;
            }
        });
    }

    static interface Configurator
    extends ConfigurationResourceDefinitionRegistrar.Configurator<MemoryConfiguration> {
        public StorageType getStorageType();

        default public EnumAttributeDefinition<MemorySizeUnit> getSizeUnitAttribute() {
            return SIZE_UNIT;
        }

        @Override
        default public RuntimeCapability<Void> getCapability() {
            return CAPABILITY;
        }
    }
}

