/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.configuration;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.lock.configuration.Attribute;
import org.infinispan.lock.configuration.ClusteredLockConfigurationBuilder;
import org.infinispan.lock.configuration.ClusteredLockManagerConfigurationBuilder;
import org.infinispan.lock.configuration.Element;
import org.infinispan.lock.configuration.Reliability;
import org.infinispan.lock.logging.Log;

@Namespaces(value={@Namespace(root="clustered-locks"), @Namespace(uri="urn:infinispan:config:clustered-locks:*", root="clustered-locks", since="9.4")})
public class ClusteredLockConfigurationParser
implements ConfigurationParser {
    static final String NAMESPACE = "urn:infinispan:config:clustered-locks:";
    private static final Log log = (Log)LogFactory.getLog(ClusteredLockConfigurationParser.class, Log.class);

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        if (!holder.inScope((Enum)ParserScope.CACHE_CONTAINER)) {
            throw log.invalidScope(holder.getScope());
        }
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case CLUSTERED_LOCKS: {
                this.parseClusteredLocksElement(reader, (ClusteredLockManagerConfigurationBuilder)builder.addModule(ClusteredLockManagerConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseClusteredLocksElement(ConfigurationReader reader, ClusteredLockManagerConfigurationBuilder builder) {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NUM_OWNERS: {
                    builder.numOwner(Integer.parseInt(value));
                    continue block7;
                }
                case RELIABILITY: {
                    builder.reliability(Reliability.valueOf(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.inTag()) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTERED_LOCK: {
                    this.parseClusteredLock(reader, builder.addClusteredLock());
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
        }
    }

    private void parseClusteredLock(ConfigurationReader reader, ClusteredLockConfigurationBuilder builder) {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    builder.name(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((ConfigurationReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((ConfigurationReader)reader);
    }
}

